/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.StatisticPoint;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public abstract class SingleStatistic<P extends StatisticPoint> {
    protected final SingleBenchmarkResult singleBenchmarkResult;
    protected final StatisticType statisticType;

    protected SingleStatistic(SingleBenchmarkResult singleBenchmarkResult, StatisticType statisticType) {
        this.singleBenchmarkResult = singleBenchmarkResult;
        this.statisticType = statisticType;
    }

    public StatisticType getStatisticType() {
        return this.statisticType;
    }

    public abstract List<P> getPointList();

    public abstract void setPointList(List<P> var1);

    public String getCsvFilePath() {
        return this.singleBenchmarkResult.getSingleReportDirectoryPath() + "/" + this.statisticType.name() + ".csv";
    }

    public File getCsvFile() {
        return new File(this.singleBenchmarkResult.getBenchmarkReportDirectory(), this.getCsvFilePath());
    }

    public abstract void open(Solver var1);

    public abstract void close(Solver var1);

    protected abstract String getCsvHeader();

    public void writeCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "UTF-8");
            ((Writer)writer).append(this.getCsvHeader()).append("\n");
            for (StatisticPoint point : this.getPointList()) {
                ((Writer)writer).append(point.toCsvLine()).append("\n");
            }
            if (this.singleBenchmarkResult.isFailure()) {
                ((Writer)writer).append("Failed\n");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Failed writing csvFile (" + csvFile + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        ScoreDefinition scoreDefinition = this.singleBenchmarkResult.getSolverBenchmarkResult().getSolverConfig().getScoreDirectorFactoryConfig().buildScoreDefinition();
        List<Object> pointList = this.getPointList();
        if (!pointList.isEmpty()) {
            throw new IllegalStateException("The pointList with size (" + pointList.size() + ") should be empty.");
        }
        if (!csvFile.exists()) {
            if (!this.singleBenchmarkResult.isFailure()) throw new IllegalStateException("The csvFile (" + csvFile + ") does not exist.");
            pointList = Collections.emptyList();
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8"));
            String line = reader.readLine();
            if (!this.getCsvHeader().equals(line)) {
                throw new IllegalStateException("The read line (" + line + ") is expected to be the header line (" + this.getCsvHeader() + ") for statisticType (" + this.statisticType + ").");
            }
            line = reader.readLine();
            while (line != null && !line.isEmpty()) {
                List<String> csvLine = StatisticPoint.parseCsvLine(line);
                pointList.add(this.createPointFromCsvLine(scoreDefinition, csvLine));
                line = reader.readLine();
            }
        }
        catch (RuntimeException e) {
            try {
                throw new IllegalArgumentException("Failed reading csvFile (" + csvFile + ").", e);
                catch (IOException e2) {
                    throw new IllegalArgumentException("Failed reading csvFile (" + csvFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    protected abstract P createPointFromCsvLine(ScoreDefinition var1, List<String> var2);
}

