/*
 * Copyright 2014 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaplanner.benchmark.impl.statistic.single.constraintmatchtotalstepscore;

import org.optaplanner.benchmark.impl.statistic.StatisticPoint;

public class ConstraintMatchTotalStepScoreStatisticPoint extends StatisticPoint {

    private final long timeMillisSpent;
    protected final String constraintPackage;
    protected final String constraintName;
    protected final int scoreLevel;
    private final int constraintMatchCount;
    private final double weightTotal;

    public ConstraintMatchTotalStepScoreStatisticPoint(long timeMillisSpent,
            String constraintPackage, String constraintName, int scoreLevel,
            int constraintMatchCount, double weightTotal) {
        this.timeMillisSpent = timeMillisSpent;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.scoreLevel = scoreLevel;
        this.constraintMatchCount = constraintMatchCount;
        this.weightTotal = weightTotal;
    }

    public long getTimeMillisSpent() {
        return timeMillisSpent;
    }

    public String getConstraintPackage() {
        return constraintPackage;
    }

    public String getConstraintName() {
        return constraintName;
    }

    public int getScoreLevel() {
        return scoreLevel;
    }

    public int getConstraintMatchCount() {
        return constraintMatchCount;
    }

    public double getWeightTotal() {
        return weightTotal;
    }

    @Override
    public String toCsvLine() {
        return buildCsvLineWithStrings(timeMillisSpent, constraintPackage, constraintName, Integer.toString(scoreLevel),
                Integer.toString(constraintMatchCount), Double.toString(weightTotal));
    }

}
