/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.memoryuse;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseMeasurement;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;

public class MemoryUseSingleStatistic
extends ProblemBasedSingleStatistic<MemoryUseStatisticPoint> {
    private long timeMillisThresholdInterval;
    private MemoryUseSingleStatisticListener listener;

    public MemoryUseSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        this(singleBenchmarkResult, 1000L);
    }

    public MemoryUseSingleStatistic(SingleBenchmarkResult singleBenchmarkResult, long timeMillisThresholdInterval) {
        super(singleBenchmarkResult, ProblemStatisticType.MEMORY_USE);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.listener = new MemoryUseSingleStatisticListener();
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return MemoryUseStatisticPoint.buildCsvLine("timeMillisSpent", "usedMemory", "maxMemory");
    }

    @Override
    protected MemoryUseStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new MemoryUseStatisticPoint(Long.valueOf(csvLine.get(0)), new MemoryUseMeasurement(Long.valueOf(csvLine.get(1)), Long.valueOf(csvLine.get(2))));
    }

    private class MemoryUseSingleStatisticListener
    extends PhaseLifecycleListenerAdapter {
        private long nextTimeMillisThreshold;

        private MemoryUseSingleStatisticListener() {
            this.nextTimeMillisThreshold = MemoryUseSingleStatistic.this.timeMillisThresholdInterval;
        }

        public void stepEnded(AbstractStepScope stepScope) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpent();
            if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                MemoryUseSingleStatistic.this.pointList.add(new MemoryUseStatisticPoint(timeMillisSpent, MemoryUseMeasurement.create()));
                this.nextTimeMillisThreshold += MemoryUseSingleStatistic.this.timeMillisThresholdInterval;
                if (this.nextTimeMillisThreshold < timeMillisSpent) {
                    this.nextTimeMillisThreshold = timeMillisSpent;
                }
            }
        }
    }
}

