/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import com.thoughtworks.xstream.annotations.XStreamInclude;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticPoint;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamInclude(value={PureSingleStatistic.class})
public abstract class SingleStatistic<P extends StatisticPoint> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @XStreamOmitField
    protected SingleBenchmarkResult singleBenchmarkResult;
    @XStreamOmitField
    protected List<P> pointList;

    protected SingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        this.singleBenchmarkResult = singleBenchmarkResult;
        this.initPointList();
    }

    public SingleBenchmarkResult getSingleBenchmarkResult() {
        return this.singleBenchmarkResult;
    }

    public void setSingleBenchmarkResult(SingleBenchmarkResult singleBenchmarkResult) {
        this.singleBenchmarkResult = singleBenchmarkResult;
    }

    public abstract StatisticType getStatisticType();

    public List<P> getPointList() {
        return this.pointList;
    }

    public void setPointList(List<P> pointList) {
        this.pointList = pointList;
    }

    public String getCsvFilePath() {
        return this.singleBenchmarkResult.getSingleReportDirectoryPath() + "/" + this.getStatisticType().name() + ".csv";
    }

    public File getCsvFile() {
        return new File(this.singleBenchmarkResult.getBenchmarkReportDirectory(), this.getCsvFilePath());
    }

    public abstract void open(Solver var1);

    public abstract void close(Solver var1);

    public void initPointList() {
        this.pointList = new ArrayList<P>();
    }

    protected abstract String getCsvHeader();

    public void writeCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "UTF-8");
            ((Writer)writer).append(this.getCsvHeader()).append("\n");
            for (StatisticPoint point : this.getPointList()) {
                ((Writer)writer).append(point.toCsvLine()).append("\n");
            }
            if (this.singleBenchmarkResult.isFailure()) {
                ((Writer)writer).append("Failed\n");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Failed writing csvFile (" + csvFile + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        ScoreDefinition scoreDefinition = this.singleBenchmarkResult.getSolverBenchmarkResult().getSolverConfig().getScoreDirectorFactoryConfig().buildScoreDefinition();
        if (!this.pointList.isEmpty()) {
            throw new IllegalStateException("The pointList with size (" + this.pointList.size() + ") should be empty.");
        }
        if (!csvFile.exists()) {
            if (!this.singleBenchmarkResult.isFailure()) throw new IllegalStateException("The csvFile (" + csvFile + ") does not exist.");
            this.pointList = Collections.emptyList();
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8"));
            String line = reader.readLine();
            if (!this.getCsvHeader().equals(line)) {
                throw new IllegalStateException("The read line (" + line + ") is expected to be the header line (" + this.getCsvHeader() + ") for statisticType (" + this.getStatisticType() + ").");
            }
            HashMap<String, String> stringDuplicationRemovalMap = new HashMap<String, String>(1024);
            line = reader.readLine();
            while (line != null && !line.isEmpty()) {
                List<String> csvLine = StatisticPoint.parseCsvLine(line);
                ListIterator<String> it = csvLine.listIterator();
                while (it.hasNext()) {
                    String token = it.next();
                    if (token == null) continue;
                    String originalToken = (String)stringDuplicationRemovalMap.get(token);
                    if (originalToken == null) {
                        stringDuplicationRemovalMap.put(token, token);
                        continue;
                    }
                    it.set(originalToken);
                }
                this.pointList.add(this.createPointFromCsvLine(scoreDefinition, csvLine));
                line = reader.readLine();
            }
        }
        catch (RuntimeException e) {
            try {
                throw new IllegalArgumentException("Failed reading csvFile (" + csvFile + ").", e);
                catch (IOException e2) {
                    throw new IllegalArgumentException("Failed reading csvFile (" + csvFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    protected abstract P createPointFromCsvLine(ScoreDefinition var1, List<String> var2);

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.singleBenchmarkResult.getName() + "_" + this.getStatisticType().name());
    }
}

