/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkException;
import org.optaplanner.benchmark.impl.SingleBenchmarkRunner;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.BenchmarkResultIO;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlannerBenchmarkRunner
implements PlannerBenchmark {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PlannerBenchmarkResult plannerBenchmarkResult;
    private File benchmarkDirectory = null;
    private BenchmarkReport benchmarkReport = null;
    private ExecutorService executorService;
    private BenchmarkResultIO benchmarkResultIO;
    private long startingSystemTimeMillis = -1L;
    private SingleBenchmarkRunner firstFailureSingleBenchmarkRunner = null;

    public PlannerBenchmarkRunner(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public BenchmarkReport getBenchmarkReport() {
        return this.benchmarkReport;
    }

    public void setBenchmarkReport(BenchmarkReport benchmarkReport) {
        this.benchmarkReport = benchmarkReport;
    }

    @Override
    public void benchmark() {
        this.benchmarkingStarted();
        this.warmUp();
        this.runSingleBenchmarks();
        this.benchmarkingEnded();
    }

    public void benchmarkingStarted() {
        if (this.startingSystemTimeMillis >= 0L) {
            throw new IllegalStateException("This benchmark has already ran before.");
        }
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.plannerBenchmarkResult.setStartingTimestamp(new Date());
        List<SolverBenchmarkResult> solverBenchmarkResultList = this.plannerBenchmarkResult.getSolverBenchmarkResultList();
        if (ConfigUtils.isEmptyCollection(solverBenchmarkResultList)) {
            throw new IllegalArgumentException("The solverBenchmarkResultList (" + solverBenchmarkResultList + ") cannot be empty.");
        }
        this.initBenchmarkDirectoryAndSubdirs();
        this.plannerBenchmarkResult.initSystemProperties();
        this.executorService = Executors.newFixedThreadPool(this.plannerBenchmarkResult.getParallelBenchmarkCount());
        this.benchmarkResultIO = new BenchmarkResultIO();
        this.logger.info("Benchmarking started: solverBenchmarkResultList size ({}), parallelBenchmarkCount ({}).", (Object)solverBenchmarkResultList.size(), (Object)this.plannerBenchmarkResult.getParallelBenchmarkCount());
    }

    private void initBenchmarkDirectoryAndSubdirs() {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        this.benchmarkDirectory.mkdirs();
        this.plannerBenchmarkResult.initBenchmarkReportDirectory(this.benchmarkDirectory);
    }

    private void warmUp() {
        if (this.plannerBenchmarkResult.getWarmUpTimeMillisSpentLimit() > 0L) {
            this.logger.info("================================================================================");
            this.logger.info("Warm up started");
            this.logger.info("================================================================================");
            long startingTimeMillis = System.currentTimeMillis();
            long timeLeft = this.plannerBenchmarkResult.getWarmUpTimeMillisSpentLimit();
            List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList();
            Iterator<ProblemBenchmarkResult> it = unifiedProblemBenchmarkResultList.iterator();
            while (timeLeft > 0L) {
                if (!it.hasNext()) {
                    it = unifiedProblemBenchmarkResultList.iterator();
                }
                ProblemBenchmarkResult problemBenchmarkResult = it.next();
                timeLeft = this.warmUp(problemBenchmarkResult, startingTimeMillis, this.plannerBenchmarkResult.getWarmUpTimeMillisSpentLimit(), timeLeft);
            }
            this.logger.info("================================================================================");
            this.logger.info("Warm up ended");
            this.logger.info("================================================================================");
        }
    }

    protected long warmUp(ProblemBenchmarkResult problemBenchmarkResult, long startingTimeMillis, long warmUpTimeMillisSpentLimit, long timeLeft) {
        for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
            SolverBenchmarkResult solverBenchmarkResult = singleBenchmarkResult.getSolverBenchmarkResult();
            TerminationConfig originalTerminationConfig = solverBenchmarkResult.getSolverConfig().getTerminationConfig();
            TerminationConfig tmpTerminationConfig = originalTerminationConfig == null ? new TerminationConfig() : originalTerminationConfig.clone();
            tmpTerminationConfig.shortenTimeMillisSpentLimit(timeLeft);
            solverBenchmarkResult.getSolverConfig().setTerminationConfig(tmpTerminationConfig);
            try {
                Solver solver = solverBenchmarkResult.getSolverConfig().buildSolver();
                solver.solve(problemBenchmarkResult.readPlanningProblem());
            }
            catch (RuntimeException e) {
                this.logger.error("The warmUp of singleBenchmark (" + singleBenchmarkResult.getName() + ") failed.", (Throwable)e);
            }
            solverBenchmarkResult.getSolverConfig().setTerminationConfig(originalTerminationConfig);
            long timeSpent = System.currentTimeMillis() - startingTimeMillis;
            timeLeft = warmUpTimeMillisSpentLimit - timeSpent;
            if (timeLeft > 0L) continue;
            return timeLeft;
        }
        return timeLeft;
    }

    protected void runSingleBenchmarks() {
        HashMap<SingleBenchmarkRunner, Future<SingleBenchmarkRunner>> futureMap = new HashMap<SingleBenchmarkRunner, Future<SingleBenchmarkRunner>>();
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                SingleBenchmarkRunner singleBenchmarkRunner = new SingleBenchmarkRunner(singleBenchmarkResult);
                Future<SingleBenchmarkRunner> future = this.executorService.submit(singleBenchmarkRunner);
                futureMap.put(singleBenchmarkRunner, future);
            }
        }
        for (Map.Entry entry : futureMap.entrySet()) {
            SingleBenchmarkRunner singleBenchmarkRunner = (SingleBenchmarkRunner)entry.getKey();
            Future future = (Future)entry.getValue();
            Throwable failureThrowable = null;
            try {
                singleBenchmarkRunner = (SingleBenchmarkRunner)future.get();
                if (singleBenchmarkRunner.getSingleBenchmarkResult().getScore() == null) {
                    throw new IllegalStateException("Score is null. TODO fix PLANNER-46.");
                }
            }
            catch (InterruptedException e) {
                this.logger.error("The singleBenchmarkRunner (" + singleBenchmarkRunner.getName() + ") was interrupted.", (Throwable)e);
                failureThrowable = e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                this.logger.error("The singleBenchmarkRunner (" + singleBenchmarkRunner.getName() + ") failed.", cause);
                failureThrowable = cause;
            }
            catch (IllegalStateException e) {
                this.logger.error("The singleBenchmarkRunner (" + singleBenchmarkRunner.getName() + ") failed.", (Throwable)e);
                failureThrowable = e;
            }
            if (failureThrowable == null) {
                singleBenchmarkRunner.getSingleBenchmarkResult().setSucceeded(true);
                continue;
            }
            singleBenchmarkRunner.getSingleBenchmarkResult().setSucceeded(false);
            singleBenchmarkRunner.setFailureThrowable(failureThrowable);
            if (this.firstFailureSingleBenchmarkRunner != null) continue;
            this.firstFailureSingleBenchmarkRunner = singleBenchmarkRunner;
        }
    }

    public void benchmarkingEnded() {
        List<Runnable> notExecutedBenchmarkList = this.executorService.shutdownNow();
        if (!notExecutedBenchmarkList.isEmpty()) {
            throw new IllegalStateException("Impossible state: notExecutedBenchmarkList size (" + notExecutedBenchmarkList + ").");
        }
        this.plannerBenchmarkResult.setBenchmarkTimeMillisSpent(this.calculateTimeMillisSpent());
        this.benchmarkResultIO.writePlannerBenchmarkResult(this.plannerBenchmarkResult.getBenchmarkReportDirectory(), this.plannerBenchmarkResult);
        this.benchmarkReport.writeReport();
        if (this.plannerBenchmarkResult.getFailureCount() != 0) {
            this.logger.info("Benchmarking failed: time spent ({}), failureCount ({}), statistic html overview ({}).", new Object[]{this.plannerBenchmarkResult.getBenchmarkTimeMillisSpent(), this.plannerBenchmarkResult.getFailureCount(), this.benchmarkReport.getHtmlOverviewFile().getAbsolutePath()});
            throw new PlannerBenchmarkException("Benchmarking failed: failureCount (" + this.plannerBenchmarkResult.getFailureCount() + ")." + " The exception of the firstFailureSingleBenchmarkRunner (" + this.firstFailureSingleBenchmarkRunner.getName() + ") is chained.", this.firstFailureSingleBenchmarkRunner.getFailureThrowable());
        }
        this.logger.info("Benchmarking ended: time spent ({}), favoriteSolverBenchmark ({}), statistic html overview ({}).", new Object[]{this.plannerBenchmarkResult.getBenchmarkTimeMillisSpent(), this.plannerBenchmarkResult.getFavoriteSolverBenchmarkResult().getName(), this.benchmarkReport.getHtmlOverviewFile().getAbsolutePath()});
    }

    public long calculateTimeMillisSpent() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }
}

