/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.ranking.SingleBenchmarkRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSingleStatistic;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="problemBenchmarkResult")
public class ProblemBenchmarkResult {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @XStreamOmitField
    private PlannerBenchmarkResult plannerBenchmarkResult;
    private String name = null;
    @XStreamOmitField
    private SolutionFileIO solutionFileIO = null;
    private boolean writeOutputSolutionEnabled = false;
    private File inputSolutionFile = null;
    @XStreamImplicit
    private List<ProblemStatistic> problemStatisticList = null;
    @XStreamImplicit
    private List<SingleBenchmarkResult> singleBenchmarkResultList = null;
    private Long entityCount = null;
    private Long variableCount = null;
    private Long problemScale = null;
    private Long averageUsedMemoryAfterInputSolution = null;
    private Integer failureCount = null;
    private SingleBenchmarkResult winningSingleBenchmarkResult = null;
    private SingleBenchmarkResult worstSingleBenchmarkResult = null;

    public ProblemBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public void setPlannerBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolutionFileIO getSolutionFileIO() {
        return this.solutionFileIO;
    }

    public void setSolutionFileIO(SolutionFileIO solutionFileIO) {
        this.solutionFileIO = solutionFileIO;
    }

    public boolean isWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public File getInputSolutionFile() {
        return this.inputSolutionFile;
    }

    public void setInputSolutionFile(File inputSolutionFile) {
        this.inputSolutionFile = inputSolutionFile;
    }

    public List<ProblemStatistic> getProblemStatisticList() {
        return this.problemStatisticList;
    }

    public void setProblemStatisticList(List<ProblemStatistic> problemStatisticList) {
        this.problemStatisticList = problemStatisticList;
    }

    public List<SingleBenchmarkResult> getSingleBenchmarkResultList() {
        return this.singleBenchmarkResultList;
    }

    public void setSingleBenchmarkResultList(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        this.singleBenchmarkResultList = singleBenchmarkResultList;
    }

    public Long getEntityCount() {
        return this.entityCount;
    }

    public Long getVariableCount() {
        return this.variableCount;
    }

    public Long getProblemScale() {
        return this.problemScale;
    }

    public Long getAverageUsedMemoryAfterInputSolution() {
        return this.averageUsedMemoryAfterInputSolution;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public SingleBenchmarkResult getWinningSingleBenchmarkResult() {
        return this.winningSingleBenchmarkResult;
    }

    public SingleBenchmarkResult getWorstSingleBenchmarkResult() {
        return this.worstSingleBenchmarkResult;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.name);
    }

    public File getBenchmarkReportDirectory() {
        return this.plannerBenchmarkResult.getBenchmarkReportDirectory();
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public boolean hasAnySuccess() {
        return this.singleBenchmarkResultList.size() - this.failureCount > 0;
    }

    public boolean hasAnyStatistic() {
        if (this.problemStatisticList.size() > 0) {
            return true;
        }
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (singleBenchmarkResult.getPureSingleStatisticList().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasProblemStatisticType(ProblemStatisticType problemStatisticType) {
        for (ProblemStatistic problemStatistic : this.problemStatisticList) {
            if (problemStatistic.getProblemStatisticType() != problemStatisticType) continue;
            return true;
        }
        return false;
    }

    public Collection<SingleStatisticType> extractSingleStatisticTypeList() {
        LinkedHashSet<SingleStatisticType> singleStatisticTypeSet = new LinkedHashSet<SingleStatisticType>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            for (PureSingleStatistic pureSingleStatistic : singleBenchmarkResult.getPureSingleStatisticList()) {
                singleStatisticTypeSet.add(pureSingleStatistic.getStatisticType());
            }
        }
        return singleStatisticTypeSet;
    }

    public List<PureSingleStatistic> extractPureSingleStatisticList(SingleStatisticType singleStatisticType) {
        ArrayList<PureSingleStatistic> pureSingleStatisticList = new ArrayList<PureSingleStatistic>(this.singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            for (PureSingleStatistic pureSingleStatistic : singleBenchmarkResult.getPureSingleStatisticList()) {
                if (pureSingleStatistic.getStatisticType() != singleStatisticType) continue;
                pureSingleStatisticList.add(pureSingleStatistic);
            }
        }
        return pureSingleStatisticList;
    }

    public String getProblemReportDirectoryPath() {
        return this.name;
    }

    public File getProblemReportDirectory() {
        return new File(this.getBenchmarkReportDirectory(), this.name);
    }

    public void makeDirs(File benchmarkReportDirectory) {
        File problemReportDirectory = this.getProblemReportDirectory();
        problemReportDirectory.mkdirs();
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            singleBenchmarkResult.makeDirs(problemReportDirectory);
        }
    }

    public Solution readPlanningProblem() {
        return this.solutionFileIO.read(this.inputSolutionFile);
    }

    public void writeOutputSolution(SingleBenchmarkResult singleBenchmarkResult, Solution outputSolution) {
        if (!this.writeOutputSolutionEnabled) {
            return;
        }
        String filename = this.getName() + "." + this.solutionFileIO.getOutputFileExtension();
        File outputSolutionFile = new File(singleBenchmarkResult.getSingleReportDirectory(), filename);
        this.solutionFileIO.write(outputSolution, outputSolutionFile);
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            singleBenchmarkResult.accumulateResults(benchmarkReport);
        }
        this.determineTotalsAndAveragesAndRanking();
        this.determineWinningScoreDifference();
        for (ProblemStatistic problemStatistic : this.problemStatisticList) {
            problemStatistic.accumulateResults(benchmarkReport);
        }
    }

    private void determineTotalsAndAveragesAndRanking() {
        this.failureCount = 0;
        long totalUsedMemoryAfterInputSolution = 0L;
        int usedMemoryAfterInputSolutionCount = 0;
        ArrayList<SingleBenchmarkResult> successResultList = new ArrayList<SingleBenchmarkResult>(this.singleBenchmarkResultList);
        Iterator it = successResultList.iterator();
        while (it.hasNext()) {
            SingleBenchmarkResult singleBenchmarkResult = (SingleBenchmarkResult)it.next();
            if (singleBenchmarkResult.isFailure()) {
                Integer n = this.failureCount;
                Integer n2 = this.failureCount = Integer.valueOf(this.failureCount + 1);
                it.remove();
                continue;
            }
            if (singleBenchmarkResult.getUsedMemoryAfterInputSolution() == null) continue;
            totalUsedMemoryAfterInputSolution += singleBenchmarkResult.getUsedMemoryAfterInputSolution().longValue();
            ++usedMemoryAfterInputSolutionCount;
        }
        if (usedMemoryAfterInputSolutionCount > 0) {
            this.averageUsedMemoryAfterInputSolution = totalUsedMemoryAfterInputSolution / (long)usedMemoryAfterInputSolutionCount;
        }
        this.determineRanking(successResultList);
    }

    private void determineRanking(List<SingleBenchmarkResult> rankedSingleBenchmarkResultList) {
        SingleBenchmarkRankingComparator singleBenchmarkRankingComparator = new SingleBenchmarkRankingComparator();
        Collections.sort(rankedSingleBenchmarkResultList, Collections.reverseOrder(singleBenchmarkRankingComparator));
        int ranking = 0;
        SingleBenchmarkResult previousSingleBenchmarkResult = null;
        int previousSameRankingCount = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : rankedSingleBenchmarkResultList) {
            if (previousSingleBenchmarkResult != null && singleBenchmarkRankingComparator.compare(previousSingleBenchmarkResult, singleBenchmarkResult) != 0) {
                ranking += previousSameRankingCount;
                previousSameRankingCount = 0;
            }
            singleBenchmarkResult.setRanking(ranking);
            previousSingleBenchmarkResult = singleBenchmarkResult;
            ++previousSameRankingCount;
        }
        this.winningSingleBenchmarkResult = rankedSingleBenchmarkResultList.isEmpty() ? null : rankedSingleBenchmarkResultList.get(0);
        this.worstSingleBenchmarkResult = rankedSingleBenchmarkResultList.isEmpty() ? null : rankedSingleBenchmarkResultList.get(rankedSingleBenchmarkResultList.size() - 1);
    }

    private void determineWinningScoreDifference() {
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (singleBenchmarkResult.isFailure()) continue;
            singleBenchmarkResult.setWinningScoreDifference(singleBenchmarkResult.getScore().subtract(this.winningSingleBenchmarkResult.getScore()));
            singleBenchmarkResult.setWorstScoreDifferencePercentage(ScoreDifferencePercentage.calculateScoreDifferencePercentage(this.worstSingleBenchmarkResult.getScore(), singleBenchmarkResult.getScore()));
        }
    }

    public void registerScale(long registeringEntityCount, long registeringVariableCount, long registeringProblemScale) {
        if (this.entityCount == null) {
            this.entityCount = registeringEntityCount;
        } else if (this.entityCount != registeringEntityCount) {
            this.logger.warn("The problemBenchmarkResult ({}) has different entityCount values ([{},{}]).", new Object[]{this.getName(), this.entityCount, registeringEntityCount});
            this.entityCount = -1L;
        }
        if (this.variableCount == null) {
            this.variableCount = registeringVariableCount;
        } else if (this.variableCount != registeringVariableCount) {
            this.logger.warn("The problemBenchmarkResult ({}) has different variableCount values ([{},{}]).", new Object[]{this.getName(), this.variableCount, registeringVariableCount});
            this.variableCount = -1L;
        }
        if (this.problemScale == null) {
            this.problemScale = registeringProblemScale;
        } else if (this.problemScale != registeringProblemScale) {
            this.logger.warn("The problemBenchmarkResult ({}) has different problemScale values ([{},{}]).", new Object[]{this.getName(), this.problemScale, registeringProblemScale});
            this.problemScale = -1L;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemBenchmarkResult) {
            ProblemBenchmarkResult other = (ProblemBenchmarkResult)o;
            return this.inputSolutionFile.equals(other.getInputSolutionFile());
        }
        return false;
    }

    public int hashCode() {
        return this.inputSolutionFile.hashCode();
    }

    protected static Map<ProblemBenchmarkResult, ProblemBenchmarkResult> createMergeMap(PlannerBenchmarkResult newPlannerBenchmarkResult, List<SingleBenchmarkResult> singleBenchmarkResultList) {
        IdentityHashMap<ProblemBenchmarkResult, ProblemBenchmarkResult> mergeMap = new IdentityHashMap<ProblemBenchmarkResult, ProblemBenchmarkResult>();
        HashMap<File, ProblemBenchmarkResult> fileToNewResultMap = new HashMap<File, ProblemBenchmarkResult>();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            ProblemBenchmarkResult newResult;
            ProblemBenchmarkResult oldResult = singleBenchmarkResult.getProblemBenchmarkResult();
            if (mergeMap.containsKey(oldResult)) continue;
            if (!fileToNewResultMap.containsKey(oldResult.inputSolutionFile)) {
                newResult = new ProblemBenchmarkResult(newPlannerBenchmarkResult);
                newResult.name = oldResult.name;
                newResult.inputSolutionFile = oldResult.inputSolutionFile;
                newResult.problemStatisticList = new ArrayList<ProblemStatistic>(oldResult.problemStatisticList.size());
                for (ProblemStatistic oldProblemStatistic : oldResult.problemStatisticList) {
                    newResult.problemStatisticList.add(oldProblemStatistic.getProblemStatisticType().buildProblemStatistic(newResult));
                }
                newResult.singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(oldResult.singleBenchmarkResultList.size());
                newResult.entityCount = oldResult.entityCount;
                newResult.variableCount = oldResult.variableCount;
                newResult.problemScale = oldResult.problemScale;
                fileToNewResultMap.put(oldResult.inputSolutionFile, newResult);
                newPlannerBenchmarkResult.getUnifiedProblemBenchmarkResultList().add(newResult);
            } else {
                newResult = (ProblemBenchmarkResult)fileToNewResultMap.get(oldResult.inputSolutionFile);
                if (!ObjectUtils.equals((Object)oldResult.name, (Object)newResult.name)) {
                    throw new IllegalStateException("The oldResult (" + oldResult + ") and newResult (" + newResult + ") should have the same name, because they have the same inputSolutionFile (" + oldResult.inputSolutionFile + ").");
                }
                Iterator<ProblemStatistic> it = newResult.problemStatisticList.iterator();
                while (it.hasNext()) {
                    ProblemStatistic newStatistic = it.next();
                    if (oldResult.hasProblemStatisticType(newStatistic.getProblemStatisticType())) continue;
                    it.remove();
                }
                newResult.entityCount = (Long)ConfigUtils.mergeProperty((Object)oldResult.entityCount, (Object)newResult.entityCount);
                newResult.variableCount = (Long)ConfigUtils.mergeProperty((Object)oldResult.variableCount, (Object)newResult.variableCount);
                newResult.problemScale = (Long)ConfigUtils.mergeProperty((Object)oldResult.problemScale, (Object)newResult.problemScale);
            }
            mergeMap.put(oldResult, newResult);
        }
        return mergeMap;
    }

    public String toString() {
        return this.getName();
    }
}

