/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

@XStreamAlias(value="problemBenchmarks")
public class ProblemBenchmarksConfig
extends AbstractConfig<ProblemBenchmarksConfig> {
    private Class<SolutionFileIO> solutionFileIOClass = null;
    @XStreamImplicit(itemFieldName="xStreamAnnotatedClass")
    private List<Class> xStreamAnnotatedClassList = null;
    private Boolean writeOutputSolutionEnabled = null;
    @XStreamImplicit(itemFieldName="inputSolutionFile")
    private List<File> inputSolutionFileList = null;
    @XStreamImplicit(itemFieldName="problemStatisticType")
    private List<ProblemStatisticType> problemStatisticTypeList = null;
    @XStreamImplicit(itemFieldName="singleStatisticType")
    private List<SingleStatisticType> singleStatisticTypeList = null;

    public Class<SolutionFileIO> getSolutionFileIOClass() {
        return this.solutionFileIOClass;
    }

    public void setSolutionFileIOClass(Class<SolutionFileIO> solutionFileIOClass) {
        this.solutionFileIOClass = solutionFileIOClass;
    }

    public List<Class> getXStreamAnnotatedClassList() {
        return this.xStreamAnnotatedClassList;
    }

    public void setXStreamAnnotatedClassList(List<Class> xStreamAnnotatedClassList) {
        this.xStreamAnnotatedClassList = xStreamAnnotatedClassList;
    }

    public Boolean getWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(Boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public List<File> getInputSolutionFileList() {
        return this.inputSolutionFileList;
    }

    public void setInputSolutionFileList(List<File> inputSolutionFileList) {
        this.inputSolutionFileList = inputSolutionFileList;
    }

    public List<ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(List<ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public List<SingleStatisticType> getSingleStatisticTypeList() {
        return this.singleStatisticTypeList;
    }

    public void setSingleStatisticTypeList(List<SingleStatisticType> singleStatisticTypeList) {
        this.singleStatisticTypeList = singleStatisticTypeList;
    }

    public void buildProblemBenchmarkList(SolverBenchmarkResult solverBenchmarkResult) {
        this.validate(solverBenchmarkResult);
        PlannerBenchmarkResult plannerBenchmarkResult = solverBenchmarkResult.getPlannerBenchmarkResult();
        SolutionFileIO solutionFileIO = this.buildSolutionFileIO();
        ArrayList<ProblemBenchmarkResult> problemBenchmarkResultList = new ArrayList<ProblemBenchmarkResult>(this.inputSolutionFileList.size());
        List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList();
        for (File inputSolutionFile : this.inputSolutionFileList) {
            ProblemBenchmarkResult problemBenchmarkResult;
            if (!inputSolutionFile.exists()) {
                throw new IllegalArgumentException("The inputSolutionFile (" + inputSolutionFile + ") does not exist.");
            }
            ProblemBenchmarkResult newProblemBenchmarkResult = this.buildProblemBenchmark(plannerBenchmarkResult, solutionFileIO, inputSolutionFile);
            int index = unifiedProblemBenchmarkResultList.indexOf(newProblemBenchmarkResult);
            if (index < 0) {
                problemBenchmarkResult = newProblemBenchmarkResult;
                unifiedProblemBenchmarkResultList.add(problemBenchmarkResult);
            } else {
                problemBenchmarkResult = unifiedProblemBenchmarkResultList.get(index);
            }
            problemBenchmarkResultList.add(problemBenchmarkResult);
            this.buildSingleBenchmark(solverBenchmarkResult, problemBenchmarkResult);
        }
    }

    private void validate(SolverBenchmarkResult solverBenchmarkResult) {
        if (ConfigUtils.isEmptyCollection(this.inputSolutionFileList)) {
            throw new IllegalArgumentException("Configure at least 1 <inputSolutionFile> for the solverBenchmarkResult (" + solverBenchmarkResult.getName() + ") directly or indirectly by inheriting it.");
        }
    }

    private SolutionFileIO buildSolutionFileIO() {
        if (this.solutionFileIOClass != null && this.xStreamAnnotatedClassList != null) {
            throw new IllegalArgumentException("Cannot use solutionFileIOClass (" + this.solutionFileIOClass + ") and xStreamAnnotatedClassList (" + this.xStreamAnnotatedClassList + ") together.");
        }
        if (this.solutionFileIOClass != null) {
            return (SolutionFileIO)ConfigUtils.newInstance((Object)((Object)this), (String)"solutionFileIOClass", this.solutionFileIOClass);
        }
        Class[] xStreamAnnotatedClasses = this.xStreamAnnotatedClassList != null ? this.xStreamAnnotatedClassList.toArray(new Class[this.xStreamAnnotatedClassList.size()]) : new Class[]{};
        return new XStreamSolutionFileIO(xStreamAnnotatedClasses);
    }

    private ProblemBenchmarkResult buildProblemBenchmark(PlannerBenchmarkResult plannerBenchmarkResult, SolutionFileIO solutionFileIO, File inputSolutionFile) {
        ProblemBenchmarkResult problemBenchmarkResult = new ProblemBenchmarkResult(plannerBenchmarkResult);
        String name = FilenameUtils.getBaseName((String)inputSolutionFile.getName());
        problemBenchmarkResult.setName(name);
        problemBenchmarkResult.setSolutionFileIO(solutionFileIO);
        problemBenchmarkResult.setWriteOutputSolutionEnabled(this.writeOutputSolutionEnabled == null ? false : this.writeOutputSolutionEnabled);
        problemBenchmarkResult.setInputSolutionFile(inputSolutionFile);
        ArrayList<ProblemStatistic> problemStatisticList = new ArrayList<ProblemStatistic>(this.problemStatisticTypeList == null ? 0 : this.problemStatisticTypeList.size());
        if (this.problemStatisticTypeList != null) {
            for (ProblemStatisticType problemStatisticType : this.problemStatisticTypeList) {
                problemStatisticList.add(problemStatisticType.buildProblemStatistic(problemBenchmarkResult));
            }
        }
        problemBenchmarkResult.setProblemStatisticList(problemStatisticList);
        problemBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        return problemBenchmarkResult;
    }

    private void buildSingleBenchmark(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        this.buildSubSingleBenchmarks(singleBenchmarkResult, solverBenchmarkResult.getSubSingleCount());
        for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
            subSingleBenchmarkResult.setPureSubSingleStatisticList(new ArrayList<PureSubSingleStatistic>(this.singleStatisticTypeList == null ? 0 : this.singleStatisticTypeList.size()));
        }
        if (this.singleStatisticTypeList != null) {
            for (SingleStatisticType singleStatisticType : this.singleStatisticTypeList) {
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    subSingleBenchmarkResult.getPureSubSingleStatisticList().add(singleStatisticType.buildPureSubSingleStatistic(subSingleBenchmarkResult));
                }
            }
        }
        singleBenchmarkResult.initSubSingleStatisticMaps();
        solverBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
    }

    private void buildSubSingleBenchmarks(SingleBenchmarkResult parent, int subSingleCount) {
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(subSingleCount);
        for (int i = 0; i < subSingleCount; ++i) {
            SubSingleBenchmarkResult subSingleBenchmarkResult = new SubSingleBenchmarkResult(parent, i);
            subSingleBenchmarkResultList.add(subSingleBenchmarkResult);
        }
        parent.setSubSingleBenchmarkResultList(subSingleBenchmarkResultList);
    }

    public void inherit(ProblemBenchmarksConfig inheritedConfig) {
        this.solutionFileIOClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solutionFileIOClass, inheritedConfig.getSolutionFileIOClass());
        this.xStreamAnnotatedClassList = ConfigUtils.inheritMergeableListProperty(this.xStreamAnnotatedClassList, inheritedConfig.getXStreamAnnotatedClassList());
        this.writeOutputSolutionEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.writeOutputSolutionEnabled, (Object)inheritedConfig.getWriteOutputSolutionEnabled());
        this.inputSolutionFileList = ConfigUtils.inheritMergeableListProperty(this.inputSolutionFileList, inheritedConfig.getInputSolutionFileList());
        this.problemStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.problemStatisticTypeList, inheritedConfig.getProblemStatisticTypeList());
        this.singleStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.singleStatisticTypeList, inheritedConfig.getSingleStatisticTypeList());
    }
}

