/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config.report;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Comparator;
import java.util.Locale;
import org.optaplanner.benchmark.config.ranking.SolverRankingType;
import org.optaplanner.benchmark.impl.ranking.SolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.ranking.TotalRankSolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.ranking.TotalScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.ranking.WorstScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.util.ConfigUtils;

@XStreamAlias(value="benchmarkReport")
public class BenchmarkReportConfig
extends AbstractConfig<BenchmarkReportConfig> {
    private Locale locale = null;
    private SolverRankingType solverRankingType = null;
    private Class<? extends Comparator<SolverBenchmarkResult>> solverRankingComparatorClass = null;
    private Class<? extends SolverRankingWeightFactory> solverRankingWeightFactoryClass = null;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public SolverRankingType getSolverRankingType() {
        return this.solverRankingType;
    }

    public void setSolverRankingType(SolverRankingType solverRankingType) {
        this.solverRankingType = solverRankingType;
    }

    public Class<? extends Comparator<SolverBenchmarkResult>> getSolverRankingComparatorClass() {
        return this.solverRankingComparatorClass;
    }

    public void setSolverRankingComparatorClass(Class<? extends Comparator<SolverBenchmarkResult>> solverRankingComparatorClass) {
        this.solverRankingComparatorClass = solverRankingComparatorClass;
    }

    public Class<? extends SolverRankingWeightFactory> getSolverRankingWeightFactoryClass() {
        return this.solverRankingWeightFactoryClass;
    }

    public void setSolverRankingWeightFactoryClass(Class<? extends SolverRankingWeightFactory> solverRankingWeightFactoryClass) {
        this.solverRankingWeightFactoryClass = solverRankingWeightFactoryClass;
    }

    public BenchmarkReport buildBenchmarkReport(PlannerBenchmarkResult plannerBenchmark) {
        BenchmarkReport benchmarkReport = new BenchmarkReport(plannerBenchmark);
        benchmarkReport.setLocale(this.determineLocale());
        this.supplySolverRanking(benchmarkReport);
        return benchmarkReport;
    }

    public Locale determineLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    protected void supplySolverRanking(BenchmarkReport benchmarkReport) {
        if (this.solverRankingType != null && this.solverRankingComparatorClass != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverRankingType (" + (Object)((Object)this.solverRankingType) + ") and a solverRankingComparatorClass (" + this.solverRankingComparatorClass.getName() + ") at the same time.");
        }
        if (this.solverRankingType != null && this.solverRankingWeightFactoryClass != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverRankingType (" + (Object)((Object)this.solverRankingType) + ") and a solverRankingWeightFactoryClass (" + this.solverRankingWeightFactoryClass.getName() + ") at the same time.");
        }
        if (this.solverRankingComparatorClass != null && this.solverRankingWeightFactoryClass != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverRankingComparatorClass (" + this.solverRankingComparatorClass.getName() + ") and a solverRankingWeightFactoryClass (" + this.solverRankingWeightFactoryClass.getName() + ") at the same time.");
        }
        Comparator<SolverBenchmarkResult> solverRankingComparator = null;
        SolverRankingWeightFactory solverRankingWeightFactory = null;
        if (this.solverRankingType != null) {
            switch (this.solverRankingType) {
                case TOTAL_SCORE: {
                    solverRankingComparator = new TotalScoreSolverRankingComparator();
                    break;
                }
                case WORST_SCORE: {
                    solverRankingComparator = new WorstScoreSolverRankingComparator();
                    break;
                }
                case TOTAL_RANKING: {
                    solverRankingWeightFactory = new TotalRankSolverRankingWeightFactory();
                    break;
                }
                default: {
                    throw new IllegalStateException("The solverRankingType (" + (Object)((Object)this.solverRankingType) + ") is not implemented.");
                }
            }
        }
        if (this.solverRankingComparatorClass != null) {
            solverRankingComparator = (Comparator)ConfigUtils.newInstance((Object)((Object)this), (String)"solverRankingComparatorClass", this.solverRankingComparatorClass);
        }
        if (this.solverRankingWeightFactoryClass != null) {
            solverRankingWeightFactory = (SolverRankingWeightFactory)ConfigUtils.newInstance((Object)((Object)this), (String)"solverRankingWeightFactoryClass", this.solverRankingWeightFactoryClass);
        }
        if (solverRankingComparator != null) {
            benchmarkReport.setSolverRankingComparator(solverRankingComparator);
        } else if (solverRankingWeightFactory != null) {
            benchmarkReport.setSolverRankingWeightFactory(solverRankingWeightFactory);
        } else {
            benchmarkReport.setSolverRankingComparator(new TotalScoreSolverRankingComparator());
        }
    }

    public void inherit(BenchmarkReportConfig inheritedConfig) {
        this.locale = (Locale)ConfigUtils.inheritOverwritableProperty((Object)this.locale, (Object)inheritedConfig.getLocale());
        this.solverRankingType = (SolverRankingType)((Object)ConfigUtils.inheritOverwritableProperty((Object)((Object)this.solverRankingType), (Object)((Object)inheritedConfig.getSolverRankingType())));
        this.solverRankingComparatorClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solverRankingComparatorClass, inheritedConfig.getSolverRankingComparatorClass());
        this.solverRankingWeightFactoryClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solverRankingWeightFactoryClass, inheritedConfig.getSolverRankingWeightFactoryClass());
    }
}

