/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.swing.impl;

import java.awt.Color;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.optaplanner.swing.impl.TangoColorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUtils {
    private static final Logger logger = LoggerFactory.getLogger(SwingUtils.class);
    private static final UIDefaults smallButtonUIDefaults = new UIDefaults();

    public static void fixateLookAndFeel() {
        SwingUtils.configureNimbusToTangoColors();
        SwingUtils.configureLookAndFeel("Nimbus");
    }

    protected static void configureNimbusToTangoColors() {
        UIManager.put("control", TangoColorFactory.ALUMINIUM_1);
        UIManager.put("info", TangoColorFactory.BUTTER_1);
        UIManager.put("nimbusAlertYellow", TangoColorFactory.BUTTER_2);
        UIManager.put("nimbusBase", TangoColorFactory.SKY_BLUE_3);
        UIManager.put("nimbusDisabledText", TangoColorFactory.ALUMINIUM_4);
        UIManager.put("nimbusFocus", TangoColorFactory.SKY_BLUE_1);
        UIManager.put("nimbusGreen", TangoColorFactory.CHAMELEON_1);
        UIManager.put("nimbusInfoBlue", TangoColorFactory.SKY_BLUE_2);
        UIManager.put("nimbusLightBackground", Color.WHITE);
        UIManager.put("nimbusOrange", TangoColorFactory.ORANGE_2);
        UIManager.put("nimbusRed", TangoColorFactory.SCARLET_2);
        UIManager.put("nimbusSelectedText", Color.WHITE);
        UIManager.put("nimbusSelectionBackground", TangoColorFactory.SKY_BLUE_2);
        UIManager.put("text", Color.BLACK);
        UIManager.put("activeCaption", TangoColorFactory.ALUMINIUM_3);
        UIManager.put("background", TangoColorFactory.ALUMINIUM_2);
        UIManager.put("controlDkShadow", TangoColorFactory.ALUMINIUM_4);
        UIManager.put("controlHighlight", TangoColorFactory.ALUMINIUM_1);
        UIManager.put("controlLHighlight", TangoColorFactory.ALUMINIUM_6);
        UIManager.put("controlShadow", TangoColorFactory.ALUMINIUM_2);
        UIManager.put("controlText", Color.BLACK);
        UIManager.put("desktop", TangoColorFactory.SKY_BLUE_1);
        UIManager.put("inactiveCaption", TangoColorFactory.ALUMINIUM_3);
        UIManager.put("infoText", Color.BLACK);
        UIManager.put("menu", TangoColorFactory.ALUMINIUM_1);
        UIManager.put("menuText", Color.BLACK);
        UIManager.put("nimbusBlueGrey", TangoColorFactory.ALUMINIUM_1);
        UIManager.put("nimbusBorder", TangoColorFactory.ALUMINIUM_4);
        UIManager.put("nimbusSelection", TangoColorFactory.SKY_BLUE_2);
        UIManager.put("scrollbar", TangoColorFactory.ALUMINIUM_2);
        UIManager.put("textBackground", TangoColorFactory.SKY_BLUE_1);
        UIManager.put("textForeground", Color.BLACK);
        UIManager.put("textHighlight", TangoColorFactory.SKY_BLUE_3);
        UIManager.put("textHighlightText", Color.WHITE);
        UIManager.put("textInactiveText", TangoColorFactory.ALUMINIUM_4);
    }

    protected static void configureLookAndFeel(String lookAndFeelName) {
        Exception lookAndFeelException;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!lookAndFeelName.equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
            }
            lookAndFeelException = null;
        }
        catch (UnsupportedLookAndFeelException e) {
            lookAndFeelException = e;
        }
        catch (ClassNotFoundException e) {
            lookAndFeelException = e;
        }
        catch (InstantiationException e) {
            lookAndFeelException = e;
        }
        catch (IllegalAccessException e) {
            lookAndFeelException = e;
        }
        if (lookAndFeelException != null) {
            logger.warn("Could not switch to lookAndFeel (" + lookAndFeelName + "). Layout might be incorrect.", (Throwable)lookAndFeelException);
        }
    }

    public static void increaseDefaultFont(float multiplier) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)value;
            UIManager.put(key, fontUIResource.deriveFont((float)fontUIResource.getSize() * multiplier));
        }
    }

    public static JButton makeSmallButton(JButton button) {
        button.setMargin(new Insets(0, 0, 0, 0));
        button.putClientProperty("Nimbus.Overrides", smallButtonUIDefaults);
        return button;
    }

    private SwingUtils() {
    }

    static {
        smallButtonUIDefaults.put("Button.contentMargins", new Insets(5, 5, 5, 5));
    }
}

