/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkException;
import org.optaplanner.benchmark.impl.SubSingleBenchmarkRunner;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.BenchmarkResultIO;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlannerBenchmark
implements PlannerBenchmark {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final transient Logger singleBenchmarkRunnerExceptionLogger = LoggerFactory.getLogger((String)(this.getClass().getName() + ".singleBenchmarkRunnerException"));
    private final PlannerBenchmarkResult plannerBenchmarkResult;
    private final SolverConfigContext solverConfigContext;
    private File benchmarkDirectory = null;
    private BenchmarkReport benchmarkReport = null;
    private ExecutorService warmUpExecutorService;
    private ExecutorCompletionService<SubSingleBenchmarkRunner> warmUpExecutorCompletionService;
    private ExecutorService executorService;
    private BenchmarkResultIO benchmarkResultIO;
    private long startingSystemTimeMillis = -1L;
    private SubSingleBenchmarkRunner firstFailureSubSingleBenchmarkRunner = null;

    public DefaultPlannerBenchmark(PlannerBenchmarkResult plannerBenchmarkResult) {
        this(plannerBenchmarkResult, new SolverConfigContext());
    }

    public DefaultPlannerBenchmark(PlannerBenchmarkResult plannerBenchmarkResult, SolverConfigContext solverConfigContext) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
        this.solverConfigContext = solverConfigContext;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public BenchmarkReport getBenchmarkReport() {
        return this.benchmarkReport;
    }

    public void setBenchmarkReport(BenchmarkReport benchmarkReport) {
        this.benchmarkReport = benchmarkReport;
    }

    @Override
    public void benchmark() {
        this.benchmarkingStarted();
        this.warmUp();
        this.runSingleBenchmarks();
        this.benchmarkingEnded();
    }

    public void benchmarkingStarted() {
        if (this.startingSystemTimeMillis >= 0L) {
            throw new IllegalStateException("This benchmark has already ran before.");
        }
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.plannerBenchmarkResult.setStartingTimestamp(new Date());
        List<SolverBenchmarkResult> solverBenchmarkResultList = this.plannerBenchmarkResult.getSolverBenchmarkResultList();
        if (ConfigUtils.isEmptyCollection(solverBenchmarkResultList)) {
            throw new IllegalArgumentException("The solverBenchmarkResultList (" + solverBenchmarkResultList + ") cannot be empty.");
        }
        this.initBenchmarkDirectoryAndSubdirs();
        this.plannerBenchmarkResult.initSystemProperties();
        this.warmUpExecutorService = Executors.newFixedThreadPool(this.plannerBenchmarkResult.getParallelBenchmarkCount());
        this.warmUpExecutorCompletionService = new ExecutorCompletionService(this.warmUpExecutorService);
        this.executorService = Executors.newFixedThreadPool(this.plannerBenchmarkResult.getParallelBenchmarkCount());
        this.benchmarkResultIO = new BenchmarkResultIO();
        this.logger.info("Benchmarking started: parallelBenchmarkCount ({}) for problemCount ({}), solverCount ({}), totalSubSingleCount ({}).", new Object[]{this.plannerBenchmarkResult.getParallelBenchmarkCount(), this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList().size(), solverBenchmarkResultList.size(), this.plannerBenchmarkResult.getTotalSubSingleCount()});
    }

    private void initBenchmarkDirectoryAndSubdirs() {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        this.benchmarkDirectory.mkdirs();
        this.plannerBenchmarkResult.initBenchmarkReportDirectory(this.benchmarkDirectory);
    }

    private void warmUp() {
        if (this.plannerBenchmarkResult.getWarmUpTimeMillisSpentLimit() <= 0L) {
            return;
        }
        this.logger.info("================================================================================");
        this.logger.info("Warm up started");
        this.logger.info("================================================================================");
        long timeLeftTotal = this.plannerBenchmarkResult.getWarmUpTimeMillisSpentLimit();
        int parallelBenchmarkCount = this.plannerBenchmarkResult.getParallelBenchmarkCount();
        int solverBenchmarkResultCount = this.plannerBenchmarkResult.getSolverBenchmarkResultList().size();
        int cyclesCount = ConfigUtils.ceilDivide((int)solverBenchmarkResultCount, (int)parallelBenchmarkCount);
        long timeLeftPerCycle = Math.floorDiv(timeLeftTotal, (long)cyclesCount);
        HashMap originalProblemStatisticMap = new HashMap(this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList().size());
        ConcurrentHashMap<SolverBenchmarkResult, Integer> singleBenchmarkResultIndexMap = new ConcurrentHashMap<SolverBenchmarkResult, Integer>(solverBenchmarkResultCount);
        Map warmUpConfigBackupMap = WarmUpConfigBackup.backupBenchmarkConfig(this.plannerBenchmarkResult, originalProblemStatisticMap);
        SolverBenchmarkResult[] solverBenchmarkResultCycle = new SolverBenchmarkResult[parallelBenchmarkCount];
        int solverBenchmarkResultIndex = 0;
        for (int i = 0; i < cyclesCount; ++i) {
            long timeCycleEnd = System.currentTimeMillis() + timeLeftPerCycle;
            for (int j = 0; j < parallelBenchmarkCount; ++j) {
                solverBenchmarkResultCycle[j] = this.plannerBenchmarkResult.getSolverBenchmarkResultList().get(solverBenchmarkResultIndex % solverBenchmarkResultCount);
                ++solverBenchmarkResultIndex;
            }
            ConcurrentHashMap<Future<SubSingleBenchmarkRunner>, SubSingleBenchmarkRunner> futureMap = new ConcurrentHashMap<Future<SubSingleBenchmarkRunner>, SubSingleBenchmarkRunner>(parallelBenchmarkCount);
            this.warmUpPopulate(futureMap, singleBenchmarkResultIndexMap, solverBenchmarkResultCycle, timeLeftPerCycle);
            this.warmUp(futureMap, singleBenchmarkResultIndexMap, timeCycleEnd);
        }
        WarmUpConfigBackup.restoreBenchmarkConfig(this.plannerBenchmarkResult, originalProblemStatisticMap, warmUpConfigBackupMap);
        List<Runnable> notFinishedWarmUpList = this.warmUpExecutorService.shutdownNow();
        if (!notFinishedWarmUpList.isEmpty()) {
            throw new IllegalStateException("Impossible state: notFinishedWarmUpList (" + notFinishedWarmUpList + ") is not empty.");
        }
        this.logger.info("================================================================================");
        this.logger.info("Warm up ended");
        this.logger.info("================================================================================");
    }

    private void warmUpPopulate(Map<Future<SubSingleBenchmarkRunner>, SubSingleBenchmarkRunner> futureMap, ConcurrentMap<SolverBenchmarkResult, Integer> singleBenchmarkResultIndexMap, SolverBenchmarkResult[] solverBenchmarkResultArray, long timeLeftPerSolverConfig) {
        for (SolverBenchmarkResult solverBenchmarkResult : solverBenchmarkResultArray) {
            TerminationConfig originalTerminationConfig = solverBenchmarkResult.getSolverConfig().getTerminationConfig();
            TerminationConfig tmpTerminationConfig = new TerminationConfig();
            if (originalTerminationConfig != null) {
                tmpTerminationConfig.inherit(originalTerminationConfig);
            }
            tmpTerminationConfig.shortenTimeMillisSpentLimit(timeLeftPerSolverConfig);
            solverBenchmarkResult.getSolverConfig().setTerminationConfig(tmpTerminationConfig);
            Integer singleBenchmarkResultIndex = (Integer)singleBenchmarkResultIndexMap.get(solverBenchmarkResult);
            singleBenchmarkResultIndex = singleBenchmarkResultIndex == null ? 0 : singleBenchmarkResultIndex % solverBenchmarkResult.getSingleBenchmarkResultList().size();
            SingleBenchmarkResult singleBenchmarkResult = solverBenchmarkResult.getSingleBenchmarkResultList().get(singleBenchmarkResultIndex);
            SubSingleBenchmarkRunner subSingleBenchmarkRunner = new SubSingleBenchmarkRunner(singleBenchmarkResult.getSubSingleBenchmarkResultList().get(0), this.solverConfigContext);
            Future<SubSingleBenchmarkRunner> future = this.warmUpExecutorCompletionService.submit(subSingleBenchmarkRunner);
            futureMap.put(future, subSingleBenchmarkRunner);
            singleBenchmarkResultIndexMap.put(solverBenchmarkResult, singleBenchmarkResultIndex + 1);
        }
    }

    private void warmUp(Map<Future<SubSingleBenchmarkRunner>, SubSingleBenchmarkRunner> futureMap, ConcurrentMap<SolverBenchmarkResult, Integer> singleBenchmarkResultIndexMap, long timePhaseEnd) {
        int tasksCount = futureMap.size();
        for (int i = 0; i < tasksCount; ++i) {
            SubSingleBenchmarkRunner subSingleBenchmarkRunner;
            Future<SubSingleBenchmarkRunner> future;
            try {
                future = this.warmUpExecutorCompletionService.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Waiting for a warm up singleBenchmarkRunner was interrupted.", e);
            }
            Throwable failureThrowable = null;
            try {
                subSingleBenchmarkRunner = future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                subSingleBenchmarkRunner = futureMap.get(future);
                this.singleBenchmarkRunnerExceptionLogger.error("The warm up singleBenchmarkRunner ({}) was interrupted.", (Object)subSingleBenchmarkRunner, (Object)e);
                failureThrowable = e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                subSingleBenchmarkRunner = futureMap.get(future);
                this.singleBenchmarkRunnerExceptionLogger.warn("The warm up singleBenchmarkRunner ({}) failed.", (Object)subSingleBenchmarkRunner, (Object)cause);
                failureThrowable = cause;
            }
            if (failureThrowable != null) {
                subSingleBenchmarkRunner.setFailureThrowable(failureThrowable);
                if (this.firstFailureSubSingleBenchmarkRunner == null) {
                    this.firstFailureSubSingleBenchmarkRunner = subSingleBenchmarkRunner;
                }
            }
            SolverBenchmarkResult solverBenchmarkResult = subSingleBenchmarkRunner.getSubSingleBenchmarkResult().getSingleBenchmarkResult().getSolverBenchmarkResult();
            long timeLeftInCycle = timePhaseEnd - System.currentTimeMillis();
            if (timeLeftInCycle <= 0L) continue;
            SolverBenchmarkResult[] solverBenchmarkResultSingleton = new SolverBenchmarkResult[]{solverBenchmarkResult};
            this.warmUpPopulate(futureMap, singleBenchmarkResultIndexMap, solverBenchmarkResultSingleton, timeLeftInCycle);
            ++tasksCount;
        }
    }

    protected void runSingleBenchmarks() {
        HashMap futureMap = new HashMap();
        for (ProblemBenchmarkResult problemBenchmarkResult : this.plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
            for (SingleBenchmarkResult singleBenchmarkResult : problemBenchmarkResult.getSingleBenchmarkResultList()) {
                for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                    SubSingleBenchmarkRunner subSingleBenchmarkRunner = new SubSingleBenchmarkRunner(subSingleBenchmarkResult, this.solverConfigContext);
                    Future future = this.executorService.submit(subSingleBenchmarkRunner);
                    futureMap.put(subSingleBenchmarkRunner, future);
                }
            }
        }
        for (Map.Entry entry : futureMap.entrySet()) {
            SubSingleBenchmarkRunner subSingleBenchmarkRunner = (SubSingleBenchmarkRunner)entry.getKey();
            Future future = (Future)entry.getValue();
            Throwable failureThrowable = null;
            try {
                subSingleBenchmarkRunner = (SubSingleBenchmarkRunner)future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.singleBenchmarkRunnerExceptionLogger.error("The subSingleBenchmarkRunner ({}) was interrupted.", (Object)subSingleBenchmarkRunner, (Object)e);
                failureThrowable = e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                this.singleBenchmarkRunnerExceptionLogger.warn("The subSingleBenchmarkRunner ({}) failed.", (Object)subSingleBenchmarkRunner, (Object)cause);
                failureThrowable = cause;
            }
            if (failureThrowable == null) {
                subSingleBenchmarkRunner.getSubSingleBenchmarkResult().setSucceeded(true);
                continue;
            }
            subSingleBenchmarkRunner.getSubSingleBenchmarkResult().setSucceeded(false);
            subSingleBenchmarkRunner.setFailureThrowable(failureThrowable);
            if (this.firstFailureSubSingleBenchmarkRunner != null) continue;
            this.firstFailureSubSingleBenchmarkRunner = subSingleBenchmarkRunner;
        }
    }

    public void benchmarkingEnded() {
        List<Runnable> notExecutedBenchmarkList = this.executorService.shutdownNow();
        if (!notExecutedBenchmarkList.isEmpty()) {
            throw new IllegalStateException("Impossible state: notExecutedBenchmarkList size (" + notExecutedBenchmarkList + ").");
        }
        this.plannerBenchmarkResult.setBenchmarkTimeMillisSpent(this.calculateTimeMillisSpent());
        this.benchmarkResultIO.writePlannerBenchmarkResult(this.plannerBenchmarkResult.getBenchmarkReportDirectory(), this.plannerBenchmarkResult);
        this.benchmarkReport.writeReport();
        if (this.plannerBenchmarkResult.getFailureCount() != 0) {
            this.logger.info("Benchmarking failed: time spent ({}), failureCount ({}), statistic html overview ({}).", new Object[]{this.plannerBenchmarkResult.getBenchmarkTimeMillisSpent(), this.plannerBenchmarkResult.getFailureCount(), this.benchmarkReport.getHtmlOverviewFile().getAbsolutePath()});
            throw new PlannerBenchmarkException("Benchmarking failed: failureCount (" + this.plannerBenchmarkResult.getFailureCount() + "). The exception of the firstFailureSingleBenchmarkRunner (" + this.firstFailureSubSingleBenchmarkRunner.getName() + ") is chained.", this.firstFailureSubSingleBenchmarkRunner.getFailureThrowable());
        }
        this.logger.info("Benchmarking ended: time spent ({}), favoriteSolverBenchmark ({}), statistic html overview ({}).", new Object[]{this.plannerBenchmarkResult.getBenchmarkTimeMillisSpent(), this.plannerBenchmarkResult.getFavoriteSolverBenchmarkResult().getName(), this.benchmarkReport.getHtmlOverviewFile().getAbsolutePath()});
    }

    public long calculateTimeMillisSpent() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    private static final class WarmUpConfigBackup {
        private final TerminationConfig terminationConfig;
        private final Map<SubSingleBenchmarkResult, List<PureSubSingleStatistic>> pureSubSingleStatisticMap;

        public WarmUpConfigBackup(TerminationConfig terminationConfig) {
            this.terminationConfig = terminationConfig;
            this.pureSubSingleStatisticMap = new HashMap<SubSingleBenchmarkResult, List<PureSubSingleStatistic>>();
        }

        public Map<SubSingleBenchmarkResult, List<PureSubSingleStatistic>> getPureSubSingleStatisticMap() {
            return this.pureSubSingleStatisticMap;
        }

        public TerminationConfig getTerminationConfig() {
            return this.terminationConfig;
        }

        private static void restoreBenchmarkConfig(PlannerBenchmarkResult plannerBenchmarkResult, Map<ProblemBenchmarkResult, List<ProblemStatistic>> originalProblemStatisticMap, Map<SolverBenchmarkResult, WarmUpConfigBackup> warmUpConfigBackupMap) {
            for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                WarmUpConfigBackup warmUpConfigBackup = warmUpConfigBackupMap.get(solverBenchmarkResult);
                TerminationConfig originalTerminationConfig = warmUpConfigBackup.getTerminationConfig();
                solverBenchmarkResult.getSolverConfig().setTerminationConfig(originalTerminationConfig);
                for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                    ProblemBenchmarkResult problemBenchmarkResult = singleBenchmarkResult.getProblemBenchmarkResult();
                    if (problemBenchmarkResult.getProblemStatisticList() == null || problemBenchmarkResult.getProblemStatisticList().size() <= 0) {
                        problemBenchmarkResult.setProblemStatisticList(originalProblemStatisticMap.get(problemBenchmarkResult));
                    }
                    for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                        List<PureSubSingleStatistic> pureSubSingleStatisticList = warmUpConfigBackup.getPureSubSingleStatisticMap().get(subSingleBenchmarkResult);
                        subSingleBenchmarkResult.setPureSubSingleStatisticList(pureSubSingleStatisticList);
                        subSingleBenchmarkResult.initSubSingleStatisticMap();
                    }
                    singleBenchmarkResult.initSubSingleStatisticMaps();
                }
            }
        }

        private static Map<SolverBenchmarkResult, WarmUpConfigBackup> backupBenchmarkConfig(PlannerBenchmarkResult plannerBenchmarkResult, Map<ProblemBenchmarkResult, List<ProblemStatistic>> originalProblemStatisticMap) {
            HashMap<SolverBenchmarkResult, WarmUpConfigBackup> warmUpConfigBackupMap = new HashMap<SolverBenchmarkResult, WarmUpConfigBackup>(plannerBenchmarkResult.getSolverBenchmarkResultList().size());
            for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                TerminationConfig originalTerminationConfig = solverBenchmarkResult.getSolverConfig().getTerminationConfig();
                WarmUpConfigBackup warmUpConfigBackup = new WarmUpConfigBackup(originalTerminationConfig);
                for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
                    for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                        List<PureSubSingleStatistic> originalPureSubSingleStatisticList = subSingleBenchmarkResult.getPureSubSingleStatisticList();
                        List<PureSubSingleStatistic> subSingleBenchmarkStatisticPutResult = warmUpConfigBackup.getPureSubSingleStatisticMap().put(subSingleBenchmarkResult, originalPureSubSingleStatisticList);
                        if (subSingleBenchmarkStatisticPutResult == null) continue;
                        throw new IllegalStateException("SubSingleBenchmarkStatisticMap of WarmUpConfigBackup (" + warmUpConfigBackup + ") already contained key (" + subSingleBenchmarkResult + ") with value (" + subSingleBenchmarkStatisticPutResult + ").");
                    }
                    ProblemBenchmarkResult problemBenchmarkResult = singleBenchmarkResult.getProblemBenchmarkResult();
                    originalProblemStatisticMap.putIfAbsent(problemBenchmarkResult, problemBenchmarkResult.getProblemStatisticList());
                    singleBenchmarkResult.getProblemBenchmarkResult().setProblemStatisticList(Collections.emptyList());
                    for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                        subSingleBenchmarkResult.setPureSubSingleStatisticList(Collections.emptyList());
                        subSingleBenchmarkResult.initSubSingleStatisticMap();
                    }
                }
                WarmUpConfigBackup warmUpConfigBackupPutResult = warmUpConfigBackupMap.put(solverBenchmarkResult, warmUpConfigBackup);
                if (warmUpConfigBackupPutResult == null) continue;
                throw new IllegalStateException("WarmUpConfigBackupMap already contained key (" + solverBenchmarkResult + ") with value (" + warmUpConfigBackupPutResult + ").");
            }
            return warmUpConfigBackupMap;
        }
    }
}

