/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.benchmark.impl.ranking.SingleBenchmarkRankingComparator;
import org.optaplanner.benchmark.impl.ranking.SolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.ranking.TotalScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;

public class TotalRankSolverRankingWeightFactory
implements SolverRankingWeightFactory {
    private final Comparator<SingleBenchmarkResult> singleBenchmarkRankingComparator = new SingleBenchmarkRankingComparator();

    @Override
    public Comparable createRankingWeight(List<SolverBenchmarkResult> solverBenchmarkResultList, SolverBenchmarkResult solverBenchmarkResult) {
        int betterCount = 0;
        int equalCount = 0;
        int lowerCount = 0;
        List<SingleBenchmarkResult> singleBenchmarkResultList = solverBenchmarkResult.getSingleBenchmarkResultList();
        for (SingleBenchmarkResult single : singleBenchmarkResultList) {
            List<SingleBenchmarkResult> otherSingleList = single.getProblemBenchmarkResult().getSingleBenchmarkResultList();
            for (SingleBenchmarkResult otherSingle : otherSingleList) {
                if (single == otherSingle) continue;
                int scoreComparison = this.singleBenchmarkRankingComparator.compare(single, otherSingle);
                if (scoreComparison > 0) {
                    ++betterCount;
                    continue;
                }
                if (scoreComparison == 0) {
                    ++equalCount;
                    continue;
                }
                ++lowerCount;
            }
        }
        return new TotalRankSolverRankingWeight(solverBenchmarkResult, betterCount, equalCount, lowerCount);
    }

    public static class TotalRankSolverRankingWeight
    implements Comparable<TotalRankSolverRankingWeight> {
        private final Comparator<SolverBenchmarkResult> totalScoreSolverRankingComparator = new TotalScoreSolverRankingComparator();
        private SolverBenchmarkResult solverBenchmarkResult;
        private int betterCount;
        private int equalCount;
        private int lowerCount;

        public TotalRankSolverRankingWeight(SolverBenchmarkResult solverBenchmarkResult, int betterCount, int equalCount, int lowerCount) {
            this.solverBenchmarkResult = solverBenchmarkResult;
            this.betterCount = betterCount;
            this.equalCount = equalCount;
            this.lowerCount = lowerCount;
        }

        @Override
        public int compareTo(TotalRankSolverRankingWeight other) {
            return new CompareToBuilder().append(this.betterCount, other.betterCount).append(this.equalCount, other.equalCount).append(this.lowerCount, other.lowerCount).append((Object)this.solverBenchmarkResult, (Object)other.solverBenchmarkResult, this.totalScoreSolverRankingComparator).toComparison();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof TotalRankSolverRankingWeight) {
                TotalRankSolverRankingWeight other = (TotalRankSolverRankingWeight)o;
                return new EqualsBuilder().append(this.betterCount, other.betterCount).append(this.equalCount, other.equalCount).append(this.lowerCount, other.lowerCount).appendSuper(this.totalScoreSolverRankingComparator.compare(this.solverBenchmarkResult, other.solverBenchmarkResult) == 0).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.betterCount).append(this.equalCount).append(this.lowerCount).toHashCode();
        }
    }
}

