/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import com.thoughtworks.xstream.annotations.XStreamInclude;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticPoint;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamInclude(value={PureSubSingleStatistic.class})
public abstract class SubSingleStatistic<Solution_, StatisticPoint_ extends StatisticPoint> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @XStreamOmitField
    protected SubSingleBenchmarkResult subSingleBenchmarkResult;
    @XStreamOmitField
    protected List<StatisticPoint_> pointList;

    protected SubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
    }

    public SubSingleBenchmarkResult getSubSingleBenchmarkResult() {
        return this.subSingleBenchmarkResult;
    }

    public void setSubSingleBenchmarkResult(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
    }

    public abstract StatisticType getStatisticType();

    public List<StatisticPoint_> getPointList() {
        return this.pointList;
    }

    public void setPointList(List<StatisticPoint_> pointList) {
        this.pointList = pointList;
    }

    public String getRelativeCsvFilePath() {
        SingleBenchmarkResult singleBenchmarkResult = this.subSingleBenchmarkResult.getSingleBenchmarkResult();
        return singleBenchmarkResult.getProblemBenchmarkResult().getProblemReportDirectoryName() + "/" + singleBenchmarkResult.getResultDirectoryName() + "/" + this.subSingleBenchmarkResult.getResultDirectoryName() + "/" + this.getCsvFileName();
    }

    public String getCsvFileName() {
        return this.getStatisticType().name() + ".csv";
    }

    public File getCsvFile() {
        return new File(this.subSingleBenchmarkResult.getResultDirectory(), this.getCsvFileName());
    }

    public abstract void open(Solver<Solution_> var1);

    public abstract void close(Solver<Solution_> var1);

    public void initPointList() {
        this.pointList = new ArrayList<StatisticPoint_>();
    }

    protected abstract String getCsvHeader();

    private void writeCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "UTF-8");){
            ((Writer)writer).append(this.getCsvHeader()).append("\n");
            for (StatisticPoint point : this.getPointList()) {
                ((Writer)writer).append(point.toCsvLine()).append("\n");
            }
            if (this.subSingleBenchmarkResult.hasAnyFailure()) {
                ((Writer)writer).append("Failed\n");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed writing csvFile (" + csvFile + ").", e);
        }
    }

    private void readCsvStatisticFile() {
        File csvFile = this.getCsvFile();
        ScoreDefinition scoreDefinition = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getSolverBenchmarkResult().getScoreDefinition();
        if (!this.pointList.isEmpty()) {
            throw new IllegalStateException("The pointList with size (" + this.pointList.size() + ") should be empty.");
        }
        if (!csvFile.exists()) {
            if (this.subSingleBenchmarkResult.hasAnyFailure()) {
                this.pointList = Collections.emptyList();
                return;
            }
            throw new IllegalStateException("The csvFile (" + csvFile + ") does not exist.");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8"));){
            String line = reader.readLine();
            if (!this.getCsvHeader().equals(line)) {
                throw new IllegalStateException("The read line (" + line + ") is expected to be the header line (" + this.getCsvHeader() + ") for statisticType (" + this.getStatisticType() + ").");
            }
            HashMap<String, String> stringDuplicationRemovalMap = new HashMap<String, String>(1024);
            line = reader.readLine();
            while (line != null && !line.isEmpty()) {
                if (line.equals("Failed")) {
                    if (!this.subSingleBenchmarkResult.hasAnyFailure()) {
                        throw new IllegalStateException("SubSingleStatistic (" + this + ") failed even though the corresponding subSingleBenchmarkResult (" + this.subSingleBenchmarkResult + ") is a success.");
                    }
                } else {
                    List<String> csvLine = StatisticPoint.parseCsvLine(line);
                    ListIterator<String> it = csvLine.listIterator();
                    while (it.hasNext()) {
                        String token = it.next();
                        if (token == null) continue;
                        String originalToken = (String)stringDuplicationRemovalMap.get(token);
                        if (originalToken == null) {
                            stringDuplicationRemovalMap.put(token, token);
                            continue;
                        }
                        it.set(originalToken);
                    }
                    this.pointList.add(this.createPointFromCsvLine(scoreDefinition, csvLine));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed reading csvFile (" + csvFile + ").", e);
        }
    }

    public void unhibernatePointList() {
        if (!this.getCsvFile().exists()) {
            throw new IllegalStateException("The csvFile (" + this.getCsvFile() + ") of the statistic (" + this.getStatisticType() + ") of the single benchmark (" + this.subSingleBenchmarkResult + ") doesn't exist.");
        }
        if (this.pointList != null) {
            throw new IllegalStateException("The pointList (" + this.pointList + ") of the statistic (" + this.getStatisticType() + ") of the single benchmark (" + this.subSingleBenchmarkResult + ") should be null when unhibernating.");
        }
        this.initPointList();
        this.readCsvStatisticFile();
    }

    public void hibernatePointList() {
        this.writeCsvStatisticFile();
        this.pointList = null;
    }

    protected abstract StatisticPoint_ createPointFromCsvLine(ScoreDefinition var1, List<String> var2);

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.subSingleBenchmarkResult.getName() + "_" + this.getStatisticType().name());
    }
}

