/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.XStreamXmlPlannerBenchmarkFactory;
import org.optaplanner.core.config.SolverConfigContext;

public class FreemarkerXmlPlannerBenchmarkFactory
extends PlannerBenchmarkFactory {
    protected final SolverConfigContext solverConfigContext;
    private final XStreamXmlPlannerBenchmarkFactory xmlPlannerBenchmarkFactory;

    public FreemarkerXmlPlannerBenchmarkFactory() {
        this(new SolverConfigContext());
    }

    public FreemarkerXmlPlannerBenchmarkFactory(SolverConfigContext solverConfigContext) {
        this.solverConfigContext = solverConfigContext;
        this.xmlPlannerBenchmarkFactory = new XStreamXmlPlannerBenchmarkFactory(solverConfigContext);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(String templateResource) {
        return this.configure(templateResource, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FreemarkerXmlPlannerBenchmarkFactory configure(String templateResource, Object model) {
        ClassLoader actualClassLoader = this.solverConfigContext.determineActualClassLoader();
        try (InputStream templateIn = actualClassLoader.getResourceAsStream(templateResource);){
            if (templateIn == null) {
                String errorMessage = "The templateResource (" + templateResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                if (!templateResource.startsWith("/")) throw new IllegalArgumentException(errorMessage);
                errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A templateResource now adheres to ClassLoader.getResource(String). Remove the leading slash from the templateResource if you're upgrading from 6.0.";
                throw new IllegalArgumentException(errorMessage);
            }
            FreemarkerXmlPlannerBenchmarkFactory freemarkerXmlPlannerBenchmarkFactory = this.configure(templateIn, model);
            return freemarkerXmlPlannerBenchmarkFactory;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the templateResource (" + templateResource + ") failed.", e);
        }
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(File templateFile) {
        return this.configure(templateFile, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FreemarkerXmlPlannerBenchmarkFactory configure(File templateFile, Object model) {
        try (FileInputStream templateIn = new FileInputStream(templateFile);){
            FreemarkerXmlPlannerBenchmarkFactory freemarkerXmlPlannerBenchmarkFactory = this.configure(templateIn, model);
            return freemarkerXmlPlannerBenchmarkFactory;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The templateFile (" + templateFile + ") was not found.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the templateFile (" + templateFile + ") failed.", e);
        }
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(InputStream templateIn) {
        return this.configure(templateIn, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FreemarkerXmlPlannerBenchmarkFactory configure(InputStream templateIn, Object model) {
        try (InputStreamReader reader = new InputStreamReader(templateIn, "UTF-8");){
            FreemarkerXmlPlannerBenchmarkFactory freemarkerXmlPlannerBenchmarkFactory = this.configure(reader, model);
            return freemarkerXmlPlannerBenchmarkFactory;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading failed.", e);
        }
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Reader templateReader) {
        return this.configure(templateReader, null);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Reader templateReader, Object model) {
        Template template;
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setNumberFormat("computer");
        freemarkerCfg.setDateFormat("yyyy-mm-dd");
        freemarkerCfg.setDateTimeFormat("yyyy-mm-dd HH:mm:ss.SSS z");
        freemarkerCfg.setTimeFormat("HH:mm:ss.SSS");
        String templateFilename = "benchmarkTemplate.ftl";
        try {
            template = new Template(templateFilename, templateReader, freemarkerCfg, "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read template (" + templateFilename + ") from templateReader.", e);
        }
        return this.configure(template, model);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Template template) {
        return this.configure(template, null);
    }

    public FreemarkerXmlPlannerBenchmarkFactory configure(Template template, Object model) {
        String content;
        Throwable throwable;
        try {
            throwable = null;
            try (StringWriter configWriter = new StringWriter();){
                template.process(model, (Writer)configWriter);
                content = configWriter.toString();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not write to configWriter.", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker template to configWriter.", e);
        }
        throwable = null;
        try (StringReader configReader = new StringReader(content);){
            this.xmlPlannerBenchmarkFactory.configure(configReader);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        return this;
    }

    @Override
    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        return this.xmlPlannerBenchmarkFactory.getPlannerBenchmarkConfig();
    }

    @Override
    public PlannerBenchmark buildPlannerBenchmark() {
        return this.xmlPlannerBenchmarkFactory.buildPlannerBenchmark();
    }
}

