/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.List;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.core.config.SolverConfigContext;

public class AbstractPlannerBenchmarkFactory
extends PlannerBenchmarkFactory {
    protected final SolverConfigContext solverConfigContext;
    protected PlannerBenchmarkConfig plannerBenchmarkConfig = null;

    public AbstractPlannerBenchmarkFactory() {
        this(new SolverConfigContext());
    }

    public AbstractPlannerBenchmarkFactory(SolverConfigContext solverConfigContext) {
        this.solverConfigContext = solverConfigContext;
    }

    @Override
    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        this.checkPlannerBenchmarkConfigNotNull();
        return this.plannerBenchmarkConfig;
    }

    @Override
    public PlannerBenchmark buildPlannerBenchmark() {
        this.checkPlannerBenchmarkConfigNotNull();
        return this.plannerBenchmarkConfig.buildPlannerBenchmark(this.solverConfigContext);
    }

    @Override
    @SafeVarargs
    public final <Solution_> PlannerBenchmark buildPlannerBenchmark(Solution_ ... problems) {
        this.checkPlannerBenchmarkConfigNotNull();
        return this.plannerBenchmarkConfig.buildPlannerBenchmark(this.solverConfigContext, problems);
    }

    @Override
    public <Solution_> PlannerBenchmark buildPlannerBenchmark(List<Solution_> problemList) {
        this.checkPlannerBenchmarkConfigNotNull();
        return this.plannerBenchmarkConfig.buildPlannerBenchmark(this.solverConfigContext, problemList.toArray());
    }

    public void checkPlannerBenchmarkConfigNotNull() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null, call configure(...) first.");
        }
    }
}

