/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator;

import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkAggregator {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private File benchmarkDirectory = null;
    private BenchmarkReportConfig benchmarkReportConfig = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public File aggregate(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        return this.aggregate(singleBenchmarkResultList, null);
    }

    public File aggregate(List<SingleBenchmarkResult> singleBenchmarkResultList, Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMap) {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        if (!this.benchmarkDirectory.exists()) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must exist.");
        }
        if (this.benchmarkReportConfig == null) {
            throw new IllegalArgumentException("The benchmarkReportConfig (" + (Object)((Object)this.benchmarkReportConfig) + ") must not be null.");
        }
        if (singleBenchmarkResultList.isEmpty()) {
            throw new IllegalArgumentException("The singleBenchmarkResultList (" + singleBenchmarkResultList + ") must not be empty.");
        }
        OffsetDateTime startingTimestamp = OffsetDateTime.now();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                subSingleBenchmarkResult.setSingleBenchmarkResult(singleBenchmarkResult);
            }
            singleBenchmarkResult.initSubSingleStatisticMaps();
        }
        if (solverBenchmarkResultNameMap != null) {
            for (Map.Entry entry : solverBenchmarkResultNameMap.entrySet()) {
                SolverBenchmarkResult result = (SolverBenchmarkResult)entry.getKey();
                String newName = (String)entry.getValue();
                if (result.getName().equals(newName)) continue;
                result.setName(newName);
            }
        }
        PlannerBenchmarkResult plannerBenchmarkResult = PlannerBenchmarkResult.createMergedResult(singleBenchmarkResultList);
        plannerBenchmarkResult.setStartingTimestamp(startingTimestamp);
        plannerBenchmarkResult.initBenchmarkReportDirectory(this.benchmarkDirectory);
        BenchmarkReport benchmarkReport = this.benchmarkReportConfig.buildBenchmarkReport(plannerBenchmarkResult);
        plannerBenchmarkResult.accumulateResults(benchmarkReport);
        benchmarkReport.writeReport();
        this.logger.info("Aggregation ended: statistic html overview ({}).", (Object)benchmarkReport.getHtmlOverviewFile().getAbsolutePath());
        return benchmarkReport.getHtmlOverviewFile().getAbsoluteFile();
    }
}

