/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmarkFactory;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;

public abstract class PlannerBenchmarkFactory {
    public static PlannerBenchmarkFactory createFromSolverConfigXmlResource(String solverConfigResource) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromSolverConfigXmlResource(String solverConfigResource, ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource, (ClassLoader)classLoader);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromSolverConfigXmlResource(String solverConfigResource, File benchmarkDirectory) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, benchmarkDirectory);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromSolverConfigXmlResource(String solverConfigResource, File benchmarkDirectory, ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)solverConfigResource, (ClassLoader)classLoader);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, benchmarkDirectory);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static <Solution_> PlannerBenchmarkFactory createFromSolverFactory(SolverFactory<Solution_> solverFactory) {
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig);
        SolverConfigContext solverConfigContext = ((DefaultSolverFactory)solverFactory).getSolverConfigContext();
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig, solverConfigContext);
    }

    @Deprecated
    public static <Solution_> PlannerBenchmarkFactory createFromSolverFactory(SolverFactory<Solution_> solverFactory, File benchmarkDirectory) {
        SolverConfig solverConfig = solverFactory.getSolverConfig();
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, benchmarkDirectory);
        SolverConfigContext solverConfigContext = ((DefaultSolverFactory)solverFactory).getSolverConfigContext();
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig, solverConfigContext);
    }

    public static PlannerBenchmarkFactory createFromXmlResource(String benchmarkConfigResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromXmlResource(String benchmarkConfigResource, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromXmlFile(File benchmarkConfigFile) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromXmlFile(File benchmarkConfigFile, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromXmlInputStream(InputStream in) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromXmlReader(Reader reader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(reader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromXmlReader(Reader reader, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(reader, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, Object model) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, Object model) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, Object model) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, Object model) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, model);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    @Deprecated
    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, model, classLoader);
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory create(PlannerBenchmarkConfig benchmarkConfig) {
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig);
    }

    public static PlannerBenchmarkFactory createFromKieContainerXmlResource(String benchmarkConfigResource) {
        KieContainer kieContainer = KieServices.Factory.get().getKieClasspathContainer();
        return PlannerBenchmarkFactory.createFromKieContainerXmlResource(kieContainer, benchmarkConfigResource);
    }

    public static PlannerBenchmarkFactory createFromKieContainerXmlResource(ReleaseId releaseId, String benchmarkConfigResource) {
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        return PlannerBenchmarkFactory.createFromKieContainerXmlResource(kieContainer, benchmarkConfigResource);
    }

    public static PlannerBenchmarkFactory createFromKieContainerXmlResource(KieContainer kieContainer, String benchmarkConfigResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource, kieContainer.getClassLoader());
        return new DefaultPlannerBenchmarkFactory(benchmarkConfig, new SolverConfigContext(kieContainer));
    }

    public abstract PlannerBenchmark buildPlannerBenchmark();

    public <Solution_> PlannerBenchmark buildPlannerBenchmark(List<Solution_> problemList) {
        return this.buildPlannerBenchmark(problemList.toArray());
    }

    public abstract <Solution_> PlannerBenchmark buildPlannerBenchmark(Solution_ ... var1);

    @Deprecated
    public abstract PlannerBenchmarkConfig getPlannerBenchmarkConfig();
}

