/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.io.PlannerBenchmarkConfigIO;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.io.OptaPlannerXmlSerializationException;
import org.optaplanner.core.impl.solver.thread.DefaultSolverThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="plannerBenchmark")
@XmlType(propOrder={"name", "benchmarkDirectory", "threadFactoryClass", "parallelBenchmarkCount", "warmUpMillisecondsSpentLimit", "warmUpSecondsSpentLimit", "warmUpMinutesSpentLimit", "warmUpHoursSpentLimit", "warmUpDaysSpentLimit", "benchmarkReportConfig", "inheritedSolverBenchmarkConfig", "solverBenchmarkBluePrintConfigList", "solverBenchmarkConfigList"})
public class PlannerBenchmarkConfig {
    public static final String SOLVER_NAMESPACE_PREFIX = "solver";
    public static final String XML_ELEMENT_NAME = "plannerBenchmark";
    public static final String XML_NAMESPACE = "https://www.optaplanner.org/xsd/benchmark";
    public static final String PARALLEL_BENCHMARK_COUNT_AUTO = "AUTO";
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("(?U)^[\\w\\d _\\-\\.\\(\\)]+$");
    private static final Logger logger = LoggerFactory.getLogger(PlannerBenchmarkConfig.class);
    @XmlTransient
    private ClassLoader classLoader = null;
    private String name = null;
    private File benchmarkDirectory = null;
    private Class<? extends ThreadFactory> threadFactoryClass = null;
    private String parallelBenchmarkCount = null;
    private Long warmUpMillisecondsSpentLimit = null;
    private Long warmUpSecondsSpentLimit = null;
    private Long warmUpMinutesSpentLimit = null;
    private Long warmUpHoursSpentLimit = null;
    private Long warmUpDaysSpentLimit = null;
    @XmlElement(name="benchmarkReport")
    private BenchmarkReportConfig benchmarkReportConfig = null;
    @XmlElement(name="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XmlElement(name="solverBenchmarkBluePrint")
    private List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList = null;
    @XmlElement(name="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public static PlannerBenchmarkConfig createFromSolverConfig(SolverConfig solverConfig) {
        return PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, new File("local/benchmarkReport"));
    }

    public static PlannerBenchmarkConfig createFromSolverConfig(SolverConfig solverConfig, File benchmarkDirectory) {
        PlannerBenchmarkConfig plannerBenchmarkConfig = new PlannerBenchmarkConfig();
        plannerBenchmarkConfig.setBenchmarkDirectory(benchmarkDirectory);
        SolverBenchmarkConfig solverBenchmarkConfig = new SolverBenchmarkConfig();
        solverBenchmarkConfig.setSolverConfig(new SolverConfig(solverConfig));
        plannerBenchmarkConfig.setInheritedSolverBenchmarkConfig(solverBenchmarkConfig);
        plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlResource(String benchmarkConfigResource) {
        return PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource, null);
    }

    public static PlannerBenchmarkConfig createFromXmlResource(String benchmarkConfigResource, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        block11: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream in = actualClassLoader.getResourceAsStream(benchmarkConfigResource);
            try {
                if (in == null) {
                    String errorMessage = "The benchmarkConfigResource (" + benchmarkConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                    if (benchmarkConfigResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A benchmarkConfigResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the benchmarkConfigResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OptaPlannerXmlSerializationException e) {
                    throw new IllegalArgumentException("Unmarshalling of benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
                }
            }
            in.close();
        }
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlFile(File benchmarkConfigFile) {
        return PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile, null);
    }

    public static PlannerBenchmarkConfig createFromXmlFile(File benchmarkConfigFile, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        FileInputStream in = new FileInputStream(benchmarkConfigFile);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (OptaPlannerXmlSerializationException e) {
                throw new IllegalArgumentException("Unmarshalling the benchmarkConfigFile (" + benchmarkConfigFile + ") fails.", e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The benchmarkConfigFile (" + benchmarkConfigFile + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the benchmarkConfigFile (" + benchmarkConfigFile + ") fails.", e);
            }
        }
        ((InputStream)in).close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlInputStream(InputStream in) {
        return PlannerBenchmarkConfig.createFromXmlInputStream(in, null);
    }

    public static PlannerBenchmarkConfig createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(reader, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + StandardCharsets.UTF_8 + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading fails.", e);
            }
        }
        ((Reader)reader).close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromXmlReader(Reader reader) {
        return PlannerBenchmarkConfig.createFromXmlReader(reader, null);
    }

    public static PlannerBenchmarkConfig createFromXmlReader(Reader reader, ClassLoader classLoader) {
        PlannerBenchmarkConfigIO xmlIO = new PlannerBenchmarkConfigIO();
        PlannerBenchmarkConfig benchmarkConfigObject = xmlIO.read(reader);
        if (!(benchmarkConfigObject instanceof PlannerBenchmarkConfig)) {
            throw new IllegalArgumentException("The " + PlannerBenchmarkConfig.class.getSimpleName() + "'s XML root element resolves to a different type (" + (benchmarkConfigObject == null ? null : benchmarkConfigObject.getClass().getSimpleName()) + ")." + (String)(benchmarkConfigObject instanceof SolverConfig ? "\nMaybe use " + PlannerBenchmarkFactory.class.getSimpleName() + ".createFromSolverConfigXmlResource() instead." : ""));
        }
        PlannerBenchmarkConfig benchmarkConfig = benchmarkConfigObject;
        benchmarkConfig.setClassLoader(classLoader);
        return benchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlResource(String templateResource, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        block10: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream templateIn = actualClassLoader.getResourceAsStream(templateResource);
            try {
                if (templateIn == null) {
                    String errorMessage = "The templateResource (" + templateResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                    if (templateResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A templateResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the templateResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
                if (templateIn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (templateIn != null) {
                        try {
                            templateIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the templateResource (" + templateResource + ") fails.", e);
                }
            }
            templateIn.close();
        }
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlFile(File templateFile, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        FileInputStream templateIn = new FileInputStream(templateFile);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    templateIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The templateFile (" + templateFile + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the templateFile (" + templateFile + ") fails.", e);
            }
        }
        templateIn.close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(InputStream templateIn, Object model, ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        InputStreamReader reader = new InputStreamReader(templateIn, StandardCharsets.UTF_8);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(reader, model, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + StandardCharsets.UTF_8 + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading fails.", e);
            }
        }
        ((Reader)reader).close();
        return plannerBenchmarkConfig;
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader, ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, null, classLoader);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader, Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, model, null);
    }

    public static PlannerBenchmarkConfig createFromFreemarkerXmlReader(Reader templateReader, Object model, ClassLoader classLoader) {
        String xmlContent;
        Template template;
        Configuration freemarkerConfiguration = new Configuration();
        freemarkerConfiguration.setDefaultEncoding("UTF-8");
        freemarkerConfiguration.setNumberFormat("computer");
        freemarkerConfiguration.setDateFormat("yyyy-mm-dd");
        freemarkerConfiguration.setDateTimeFormat("yyyy-mm-dd HH:mm:ss.SSS z");
        freemarkerConfiguration.setTimeFormat("HH:mm:ss.SSS");
        try {
            template = new Template("benchmarkTemplate.ftl", templateReader, freemarkerConfiguration, "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read the Freemarker template from templateReader.", e);
        }
        try (StringWriter xmlContentWriter = new StringWriter();){
            template.process(model, (Writer)xmlContentWriter);
            xmlContent = xmlContentWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalArgumentException("Can not process the Freemarker template into xmlContentWriter.", e);
        }
        try (StringReader configReader = new StringReader(xmlContent);){
            PlannerBenchmarkConfig plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(configReader, classLoader);
            return plannerBenchmarkConfig;
        }
    }

    public PlannerBenchmarkConfig() {
    }

    public PlannerBenchmarkConfig(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public String getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(String parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public Long getWarmUpMillisecondsSpentLimit() {
        return this.warmUpMillisecondsSpentLimit;
    }

    public void setWarmUpMillisecondsSpentLimit(Long warmUpMillisecondsSpentLimit) {
        this.warmUpMillisecondsSpentLimit = warmUpMillisecondsSpentLimit;
    }

    public Long getWarmUpSecondsSpentLimit() {
        return this.warmUpSecondsSpentLimit;
    }

    public void setWarmUpSecondsSpentLimit(Long warmUpSecondsSpentLimit) {
        this.warmUpSecondsSpentLimit = warmUpSecondsSpentLimit;
    }

    public Long getWarmUpMinutesSpentLimit() {
        return this.warmUpMinutesSpentLimit;
    }

    public void setWarmUpMinutesSpentLimit(Long warmUpMinutesSpentLimit) {
        this.warmUpMinutesSpentLimit = warmUpMinutesSpentLimit;
    }

    public Long getWarmUpHoursSpentLimit() {
        return this.warmUpHoursSpentLimit;
    }

    public void setWarmUpHoursSpentLimit(Long warmUpHoursSpentLimit) {
        this.warmUpHoursSpentLimit = warmUpHoursSpentLimit;
    }

    public Long getWarmUpDaysSpentLimit() {
        return this.warmUpDaysSpentLimit;
    }

    public void setWarmUpDaysSpentLimit(Long warmUpDaysSpentLimit) {
        this.warmUpDaysSpentLimit = warmUpDaysSpentLimit;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public List<SolverBenchmarkBluePrintConfig> getSolverBenchmarkBluePrintConfigList() {
        return this.solverBenchmarkBluePrintConfigList;
    }

    public void setSolverBenchmarkBluePrintConfigList(List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList) {
        this.solverBenchmarkBluePrintConfigList = solverBenchmarkBluePrintConfigList;
    }

    public List<SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        return this.buildPlannerBenchmark(new Object[0]);
    }

    public <Solution_> PlannerBenchmark buildPlannerBenchmark(Solution_[] extraProblems) {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        List<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = this.buildEffectiveSolverBenchmarkConfigList();
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setName(this.name);
        plannerBenchmarkResult.setAggregation(false);
        int parallelBenchmarkCount = this.resolveParallelBenchmarkCount();
        plannerBenchmarkResult.setParallelBenchmarkCount(parallelBenchmarkCount);
        plannerBenchmarkResult.setWarmUpTimeMillisSpentLimit((Long)ObjectUtils.defaultIfNull((Object)this.calculateWarmUpTimeMillisSpentLimit(), (Object)30L));
        plannerBenchmarkResult.setUnifiedProblemBenchmarkResultList(new ArrayList<ProblemBenchmarkResult>());
        plannerBenchmarkResult.setSolverBenchmarkResultList(new ArrayList<SolverBenchmarkResult>(effectiveSolverBenchmarkConfigList.size()));
        for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
            solverBenchmarkConfig.buildSolverBenchmark(this.classLoader, plannerBenchmarkResult, extraProblems);
        }
        BenchmarkReportConfig benchmarkReportConfig_ = this.benchmarkReportConfig == null ? new BenchmarkReportConfig() : this.benchmarkReportConfig;
        BenchmarkReport benchmarkReport = benchmarkReportConfig_.buildBenchmarkReport(plannerBenchmarkResult);
        return new DefaultPlannerBenchmark(plannerBenchmarkResult, this.benchmarkDirectory, this.buildExecutorService(parallelBenchmarkCount), this.buildExecutorService(parallelBenchmarkCount), benchmarkReport);
    }

    private ExecutorService buildExecutorService(int parallelBenchmarkCount) {
        Object threadFactory = this.threadFactoryClass != null ? (ThreadFactory)ConfigUtils.newInstance((Object)this, (String)"threadFactoryClass", this.threadFactoryClass) : new DefaultSolverThreadFactory("BenchmarkThread");
        return Executors.newFixedThreadPool(parallelBenchmarkCount, (ThreadFactory)threadFactory);
    }

    protected void validate() {
        if (this.name != null) {
            if (!VALID_NAME_PATTERN.matcher(this.name).matches()) {
                throw new IllegalStateException("The plannerBenchmark name (" + this.name + ") is invalid because it does not follow the nameRegex (" + VALID_NAME_PATTERN.pattern() + ") which might cause an illegal filename.");
            }
            if (!this.name.trim().equals(this.name)) {
                throw new IllegalStateException("The plannerBenchmark name (" + this.name + ") is invalid because it starts or ends with whitespace.");
            }
        }
        if (ConfigUtils.isEmptyCollection(this.solverBenchmarkBluePrintConfigList) && ConfigUtils.isEmptyCollection(this.solverBenchmarkConfigList)) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> (or 1 <solverBenchmarkBluePrint>) in the <plannerBenchmark> configuration.");
        }
    }

    protected void generateSolverBenchmarkConfigNames() {
        if (this.solverBenchmarkConfigList != null) {
            HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkConfigList.size());
            LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.solverBenchmarkConfigList.size());
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
                if (solverBenchmarkConfig.getName() != null) {
                    boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                    if (unique) continue;
                    throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
                }
                noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
            }
            int generatedNameIndex = 0;
            for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
                String generatedName = "Config_" + generatedNameIndex;
                while (nameSet.contains(generatedName)) {
                    generatedName = "Config_" + ++generatedNameIndex;
                }
                solverBenchmarkConfig.setName(generatedName);
                ++generatedNameIndex;
            }
        }
    }

    protected List<SolverBenchmarkConfig> buildEffectiveSolverBenchmarkConfigList() {
        ArrayList<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(0);
        if (this.solverBenchmarkConfigList != null) {
            effectiveSolverBenchmarkConfigList.addAll(this.solverBenchmarkConfigList);
        }
        if (this.solverBenchmarkBluePrintConfigList != null) {
            for (SolverBenchmarkBluePrintConfig solverBenchmarkBluePrintConfig : this.solverBenchmarkBluePrintConfigList) {
                effectiveSolverBenchmarkConfigList.addAll(solverBenchmarkBluePrintConfig.buildSolverBenchmarkConfigList());
            }
        }
        if (this.inheritedSolverBenchmarkConfig != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(this.inheritedSolverBenchmarkConfig);
            }
        }
        return effectiveSolverBenchmarkConfigList;
    }

    protected int resolveParallelBenchmarkCount() {
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        int resolvedParallelBenchmarkCount = this.parallelBenchmarkCount == null ? 1 : (this.parallelBenchmarkCount.equals(PARALLEL_BENCHMARK_COUNT_AUTO) ? this.resolveParallelBenchmarkCountAutomatically(availableProcessorCount) : ConfigUtils.resolvePoolSize((String)"parallelBenchmarkCount", (String)this.parallelBenchmarkCount, (String[])new String[]{PARALLEL_BENCHMARK_COUNT_AUTO}));
        if (resolvedParallelBenchmarkCount < 1) {
            throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") resulted in a resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") that is lower than 1.");
        }
        if (resolvedParallelBenchmarkCount > availableProcessorCount) {
            logger.warn("Because the resolvedParallelBenchmarkCount ({}) is higher than the availableProcessorCount ({}), it is reduced to availableProcessorCount.", (Object)resolvedParallelBenchmarkCount, (Object)availableProcessorCount);
            resolvedParallelBenchmarkCount = availableProcessorCount;
        }
        return resolvedParallelBenchmarkCount;
    }

    protected int resolveParallelBenchmarkCountAutomatically(int availableProcessorCount) {
        if (availableProcessorCount <= 2) {
            return 1;
        }
        if (availableProcessorCount <= 4) {
            return 2;
        }
        return availableProcessorCount / 2 + 1;
    }

    protected Long calculateWarmUpTimeMillisSpentLimit() {
        if (this.warmUpMillisecondsSpentLimit == null && this.warmUpSecondsSpentLimit == null && this.warmUpMinutesSpentLimit == null && this.warmUpHoursSpentLimit == null && this.warmUpDaysSpentLimit == null) {
            return null;
        }
        long warmUpTimeMillisSpentLimit = 0L;
        if (this.warmUpMillisecondsSpentLimit != null) {
            if (this.warmUpMillisecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpMillisecondsSpentLimit (" + this.warmUpMillisecondsSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpMillisecondsSpentLimit.longValue();
        }
        if (this.warmUpSecondsSpentLimit != null) {
            if (this.warmUpSecondsSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpSecondsSpentLimit (" + this.warmUpSecondsSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpSecondsSpentLimit * 1000L;
        }
        if (this.warmUpMinutesSpentLimit != null) {
            if (this.warmUpMinutesSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpMinutesSpentLimit (" + this.warmUpMinutesSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpMinutesSpentLimit * 60000L;
        }
        if (this.warmUpHoursSpentLimit != null) {
            if (this.warmUpHoursSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpHoursSpentLimit (" + this.warmUpHoursSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpHoursSpentLimit * 3600000L;
        }
        if (this.warmUpDaysSpentLimit != null) {
            if (this.warmUpDaysSpentLimit < 0L) {
                throw new IllegalArgumentException("The warmUpDaysSpentLimit (" + this.warmUpDaysSpentLimit + ") cannot be negative.");
            }
            warmUpTimeMillisSpentLimit += this.warmUpDaysSpentLimit * 86400000L;
        }
        return warmUpTimeMillisSpentLimit;
    }
}

