/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.scorecalculationspeed;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.scorecalculationspeed.ScoreCalculationSpeedStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class ScoreCalculationSpeedSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, ScoreCalculationSpeedStatisticPoint> {
    private final long timeMillisThresholdInterval;
    private final ScoreCalculationSpeedSubSingleStatisticListener listener;

    public ScoreCalculationSpeedSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this(subSingleBenchmarkResult, 1000L);
    }

    public ScoreCalculationSpeedSubSingleStatistic(SubSingleBenchmarkResult benchmarkResult, long timeMillisThresholdInterval) {
        super(benchmarkResult, ProblemStatisticType.SCORE_CALCULATION_SPEED);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.listener = new ScoreCalculationSpeedSubSingleStatisticListener();
    }

    @Override
    public void open(Solver<Solution_> solver) {
        ((DefaultSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver<Solution_> solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return ScoreCalculationSpeedStatisticPoint.buildCsvLine("timeMillisSpent", "scoreCalculationSpeed");
    }

    @Override
    protected ScoreCalculationSpeedStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new ScoreCalculationSpeedStatisticPoint(Long.parseLong(csvLine.get(0)), Long.parseLong(csvLine.get(1)));
    }

    private class ScoreCalculationSpeedSubSingleStatisticListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private long nextTimeMillisThreshold;
        private long lastTimeMillisSpent;
        private long lastCalculationCount;

        private ScoreCalculationSpeedSubSingleStatisticListener() {
            this.nextTimeMillisThreshold = ScoreCalculationSpeedSubSingleStatistic.this.timeMillisThresholdInterval;
            this.lastTimeMillisSpent = 0L;
            this.lastCalculationCount = 0L;
        }

        public void stepEnded(AbstractStepScope<Solution_> stepScope) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow();
            if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                SolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
                long calculationCount = solverScope.getScoreCalculationCount();
                long calculationCountInterval = calculationCount - this.lastCalculationCount;
                long timeMillisSpentInterval = timeMillisSpent - this.lastTimeMillisSpent;
                if (timeMillisSpentInterval == 0L) {
                    timeMillisSpentInterval = 1L;
                }
                long scoreCalculationSpeed = calculationCountInterval * 1000L / timeMillisSpentInterval;
                ScoreCalculationSpeedSubSingleStatistic.this.pointList.add(new ScoreCalculationSpeedStatisticPoint(timeMillisSpent, scoreCalculationSpeed));
                this.lastCalculationCount = calculationCount;
                this.lastTimeMillisSpent = timeMillisSpent;
                this.nextTimeMillisThreshold += ScoreCalculationSpeedSubSingleStatistic.this.timeMillisThresholdInterval;
                if (this.nextTimeMillisThreshold < timeMillisSpent) {
                    this.nextTimeMillisThreshold = timeMillisSpent;
                }
            }
        }
    }
}

