/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.report;

import java.time.ZoneId;
import java.util.Comparator;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.ranking.SolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.ranking.TotalRankSolverRankingWeightFactory;
import org.optaplanner.benchmark.impl.ranking.TotalScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.ranking.WorstScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.util.ConfigUtils;

public class BenchmarkReportFactory {
    private final BenchmarkReportConfig config;

    public BenchmarkReportFactory(BenchmarkReportConfig config) {
        this.config = config;
    }

    public BenchmarkReport buildBenchmarkReport(PlannerBenchmarkResult plannerBenchmark) {
        BenchmarkReport benchmarkReport = new BenchmarkReport(plannerBenchmark);
        benchmarkReport.setLocale(this.config.determineLocale());
        benchmarkReport.setTimezoneId(ZoneId.systemDefault());
        this.supplySolverRanking(benchmarkReport);
        return benchmarkReport;
    }

    protected void supplySolverRanking(BenchmarkReport benchmarkReport) {
        if (this.config.getSolverRankingType() != null && this.config.getSolverRankingComparatorClass() != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverRankingType (" + this.config.getSolverRankingType() + ") and a solverRankingComparatorClass (" + this.config.getSolverRankingComparatorClass().getName() + ") at the same time.");
        }
        if (this.config.getSolverRankingType() != null && this.config.getSolverRankingWeightFactoryClass() != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverRankingType (" + this.config.getSolverRankingType() + ") and a solverRankingWeightFactoryClass (" + this.config.getSolverRankingWeightFactoryClass().getName() + ") at the same time.");
        }
        if (this.config.getSolverRankingComparatorClass() != null && this.config.getSolverRankingWeightFactoryClass() != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverRankingComparatorClass (" + this.config.getSolverRankingComparatorClass().getName() + ") and a solverRankingWeightFactoryClass (" + this.config.getSolverRankingWeightFactoryClass().getName() + ") at the same time.");
        }
        Comparator<SolverBenchmarkResult> solverRankingComparator = null;
        SolverRankingWeightFactory solverRankingWeightFactory = null;
        if (this.config.getSolverRankingType() != null) {
            switch (this.config.getSolverRankingType()) {
                case TOTAL_SCORE: {
                    solverRankingComparator = new TotalScoreSolverRankingComparator();
                    break;
                }
                case WORST_SCORE: {
                    solverRankingComparator = new WorstScoreSolverRankingComparator();
                    break;
                }
                case TOTAL_RANKING: {
                    solverRankingWeightFactory = new TotalRankSolverRankingWeightFactory();
                    break;
                }
                default: {
                    throw new IllegalStateException("The solverRankingType (" + this.config.getSolverRankingType() + ") is not implemented.");
                }
            }
        }
        if (this.config.getSolverRankingComparatorClass() != null) {
            solverRankingComparator = (Comparator)ConfigUtils.newInstance((Object)((Object)this.config), (String)"solverRankingComparatorClass", this.config.getSolverRankingComparatorClass());
        }
        if (this.config.getSolverRankingWeightFactoryClass() != null) {
            solverRankingWeightFactory = (SolverRankingWeightFactory)ConfigUtils.newInstance((Object)((Object)this.config), (String)"solverRankingWeightFactoryClass", this.config.getSolverRankingWeightFactoryClass());
        }
        if (solverRankingComparator != null) {
            benchmarkReport.setSolverRankingComparator(solverRankingComparator);
        } else if (solverRankingWeightFactory != null) {
            benchmarkReport.setSolverRankingWeightFactory(solverRankingWeightFactory);
        } else {
            benchmarkReport.setSolverRankingComparator(new TotalScoreSolverRankingComparator());
        }
    }
}

