/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.stepscore;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.AbstractSolver;

public class StepScoreSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, StepScoreStatisticPoint> {
    private final StepScoreSubSingleStatisticListener listener = new StepScoreSubSingleStatisticListener();

    public StepScoreSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, ProblemStatisticType.STEP_SCORE);
    }

    @Override
    public void open(Solver<Solution_> solver) {
        ((AbstractSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver<Solution_> solver) {
        ((AbstractSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return StepScoreStatisticPoint.buildCsvLine("timeMillisSpent", "score");
    }

    @Override
    protected StepScoreStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new StepScoreStatisticPoint(Long.parseLong(csvLine.get(0)), scoreDefinition.parseScore(csvLine.get(1)));
    }

    private class StepScoreSubSingleStatisticListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private StepScoreSubSingleStatisticListener() {
        }

        public void stepEnded(AbstractStepScope<Solution_> stepScope) {
            if (stepScope.getScore().isSolutionInitialized()) {
                long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow();
                StepScoreSubSingleStatistic.this.pointList.add(new StepScoreStatisticPoint(timeMillisSpent, stepScope.getScore()));
            }
        }
    }
}

