/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.BavetConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactoryService;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirectorType;

public final class BavetConstraintStreamScoreDirectorFactoryService<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> {
    public ScoreDirectorType getSupportedScoreDirectorType() {
        return ScoreDirectorType.CONSTRAINT_STREAMS;
    }

    public Supplier<AbstractScoreDirectorFactory<Solution_, Score_>> buildScoreDirectorFactory(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config) {
        ConstraintStreamImplType constraintStreamImplType_ = Objects.requireNonNullElse(config.getConstraintStreamImplType(), ConstraintStreamImplType.DROOLS);
        if (constraintStreamImplType_ != ConstraintStreamImplType.BAVET) {
            return null;
        }
        if (config.getConstraintProviderClass() != null) {
            if (!ConstraintProvider.class.isAssignableFrom(config.getConstraintProviderClass())) {
                throw new IllegalArgumentException("The constraintProviderClass (" + config.getConstraintProviderClass() + ") does not implement " + ConstraintProvider.class.getSimpleName() + ".");
            }
            return () -> {
                ConstraintProvider constraintProvider = (ConstraintProvider)ConfigUtils.newInstance((Object)config, (String)"constraintProviderClass", (Class)config.getConstraintProviderClass());
                ConfigUtils.applyCustomProperties((Object)constraintProvider, (String)"constraintProviderClass", (Map)config.getConstraintProviderCustomProperties(), (String)"constraintProviderCustomProperties");
                return this.buildScoreDirectorFactory(solutionDescriptor, constraintProvider, false);
            };
        }
        if (config.getConstraintProviderCustomProperties() != null) {
            throw new IllegalStateException("If there is no constraintProviderClass (" + config.getConstraintProviderClass() + "), then there can be no constraintProviderCustomProperties (" + config.getConstraintProviderCustomProperties() + ") either.");
        }
        return null;
    }

    public boolean supportsImplType(ConstraintStreamImplType constraintStreamImplType) {
        return constraintStreamImplType == ConstraintStreamImplType.BAVET;
    }

    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, boolean droolsAlphaNetworkCompilationEnabled) {
        if (droolsAlphaNetworkCompilationEnabled) {
            throw new IllegalStateException("With Constraint Streams " + ConstraintStreamImplType.BAVET + ", there can be no droolsAlphaNetworkCompilationEnabled (" + droolsAlphaNetworkCompilationEnabled + ").");
        }
        return new BavetConstraintStreamScoreDirectorFactory(solutionDescriptor, constraintProvider);
    }
}

