/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.collection;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;

public final class TupleList<T> {
    private int size = 0;
    private TupleListEntry<T> first = null;
    private TupleListEntry<T> last = null;

    public TupleListEntry<T> add(T tuple) {
        TupleListEntry<T> entry = new TupleListEntry<T>(this, tuple, this.last);
        if (this.first == null) {
            this.first = entry;
        } else {
            this.last.next = entry;
        }
        this.last = entry;
        ++this.size;
        return entry;
    }

    public void remove(TupleListEntry<T> entry) {
        if (this.first == entry) {
            this.first = entry.next;
        } else {
            entry.previous.next = entry.next;
        }
        if (this.last == entry) {
            this.last = entry.previous;
        } else {
            entry.next.previous = entry.previous;
        }
        entry.previous = null;
        entry.next = null;
        --this.size;
    }

    public TupleListEntry<T> first() {
        return this.first;
    }

    public TupleListEntry<T> last() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    public void forEach(Consumer<T> tupleConsumer) {
        TupleListEntry<T> entry = this.first;
        while (entry != null) {
            TupleListEntry next = entry.next;
            tupleConsumer.accept(entry.getElement());
            entry = next;
        }
    }

    public String toString() {
        return "size = " + this.size;
    }
}

