/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.AbstractConstraintStream;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.drools.DroolsConstraint;
import org.optaplanner.constraint.streams.drools.DroolsConstraintFactory;
import org.optaplanner.constraint.streams.drools.common.RuleBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;

public abstract class DroolsAbstractConstraintStream<Solution_>
extends AbstractConstraintStream<Solution_> {
    protected final DroolsConstraintFactory<Solution_> constraintFactory;
    private final List<DroolsAbstractConstraintStream<Solution_>> childStreamList = new ArrayList<DroolsAbstractConstraintStream<Solution_>>(2);

    public DroolsAbstractConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(retrievalSemantics);
        this.constraintFactory = Objects.requireNonNull(constraintFactory);
    }

    protected Constraint buildConstraint(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType, Object justificationMapping, Object indictedObjectsMapping, RuleBuilder<Solution_> ruleBuilder) {
        String resolvedConstraintPackage = Objects.requireNonNullElseGet(constraintPackage, this.constraintFactory::getDefaultConstraintPackage);
        Object resolvedJustificationMapping = Objects.requireNonNullElseGet(justificationMapping, () -> ((DroolsAbstractConstraintStream)this).getDefaultJustificationMapping());
        Object resolvedIndictedObjectsMapping = Objects.requireNonNullElseGet(indictedObjectsMapping, () -> ((DroolsAbstractConstraintStream)this).getDefaultIndictedObjectsMapping());
        boolean isConstraintWeightConfigurable = constraintWeight == null;
        Function constraintWeightExtractor = isConstraintWeightConfigurable ? this.buildConstraintWeightExtractor(resolvedConstraintPackage, constraintName) : this.buildConstraintWeightExtractor(resolvedConstraintPackage, constraintName, constraintWeight);
        return new DroolsConstraint<Solution_>(this.constraintFactory, resolvedConstraintPackage, constraintName, constraintWeightExtractor, impactType, isConstraintWeightConfigurable, ruleBuilder, resolvedJustificationMapping, resolvedIndictedObjectsMapping);
    }

    public void addChildStream(DroolsAbstractConstraintStream<Solution_> childStream) {
        this.childStreamList.add(childStream);
    }

    public Collection<DroolsAbstractConstraintStream<Solution_>> getChildStreams() {
        return Collections.unmodifiableList(this.childStreamList);
    }

    public DroolsConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }
}

