/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence.jackson;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;

public final class KeySerializer<E extends AbstractPersistable>
extends JsonSerializer<E> {
    private final ObjectIdGenerator<String> idGenerator = new JacksonUniqueIdGenerator();

    public void serialize(E persistable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object jsonId = serializerProvider.findObjectId(persistable, this.idGenerator).generateId(persistable);
        jsonGenerator.writeFieldName(jsonId.toString());
    }
}

