/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.solver.score;

import java.util.HashSet;
import java.util.List;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.director.simple.SimpleScoreCalculator;
import org.optaplanner.examples.tsp.domain.Appearance;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;

public class TspSimpleScoreCalculator
implements SimpleScoreCalculator<TravelingSalesmanTour> {
    public SimpleScore calculateScore(TravelingSalesmanTour tour) {
        List<Visit> visitList = tour.getVisitList();
        HashSet<Visit> tailVisitSet = new HashSet<Visit>(visitList);
        int score = 0;
        for (Visit visit : visitList) {
            Appearance previousAppearance = visit.getPreviousAppearance();
            if (previousAppearance == null) continue;
            score -= visit.getDistanceToPreviousAppearance();
            if (!(previousAppearance instanceof Visit)) continue;
            tailVisitSet.remove(previousAppearance);
        }
        if (tour.getDomicileList().size() != 1) {
            throw new UnsupportedOperationException("The domicileList (" + tour.getDomicileList() + ") should be a singleton.");
        }
        Domicile domicile = tour.getDomicileList().get(0);
        for (Visit tailVisit : tailVisitSet) {
            if (tailVisit.getPreviousAppearance() == null) continue;
            score -= domicile.getCity().getDistance(tailVisit.getCity());
        }
        return SimpleScore.valueOf((int)score);
    }
}

