/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.InstitutionParametrization;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.PeriodPenaltyType;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.RoomPenalty;
import org.optaplanner.examples.examination.domain.RoomPenaltyType;
import org.optaplanner.examples.examination.domain.Student;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.ExamBefore;
import org.optaplanner.examples.examination.domain.solver.ExamCoincidence;
import org.optaplanner.examples.examination.persistence.ExaminationDao;

public class ExaminationSolutionImporter
extends AbstractTxtSolutionImporter {
    private static final String INPUT_FILE_SUFFIX = ".exam";
    private static final String SPLIT_REGEX = "\\,\\ ?";

    public static void main(String[] args) {
        new ExaminationSolutionImporter().convertAll();
    }

    public ExaminationSolutionImporter() {
        super(new ExaminationDao());
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new ExaminationInputBuilder();
    }

    public class ExaminationInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        @Override
        public Solution readSolution() throws IOException {
            Examination examination = new Examination();
            examination.setId(0L);
            this.readTopicListAndStudentList(examination);
            this.readPeriodList(examination);
            this.readRoomList(examination);
            String line = this.bufferedReader.readLine();
            if (!line.equals("[PeriodHardConstraints]")) {
                throw new IllegalStateException("Read line (" + line + " is not the expected header ([PeriodHardConstraints])");
            }
            this.readPeriodPenaltyList(examination);
            this.readRoomPenaltyList(examination);
            this.readInstitutionalWeighting(examination);
            this.tagFrontLoadLargeTopics(examination);
            this.tagFrontLoadLastPeriods(examination);
            this.createExamList(examination);
            int possibleForOneExamSize = examination.getPeriodList().size() * examination.getRoomList().size();
            BigInteger possibleSolutionSize = BigInteger.valueOf(possibleForOneExamSize).pow(examination.getExamList().size());
            String flooredPossibleSolutionSize = "10^" + (possibleSolutionSize.toString().length() - 1);
            ExaminationSolutionImporter.this.logger.info("Examination {} has {} students, {} exams, {} periods, {} rooms, {} period constraints and {} room constraints with a search space of {}.", new Object[]{this.getInputId(), examination.getStudentList().size(), examination.getExamList().size(), examination.getPeriodList().size(), examination.getRoomList().size(), examination.getPeriodPenaltyList().size(), examination.getRoomPenaltyList().size(), flooredPossibleSolutionSize});
            return examination;
        }

        private void readTopicListAndStudentList(Examination examination) throws IOException {
            HashMap<Integer, Student> studentMap = new HashMap<Integer, Student>();
            int examSize = this.readHeaderWithNumber("Exams");
            ArrayList<Topic> topicList = new ArrayList<Topic>(examSize);
            for (int i = 0; i < examSize; ++i) {
                Topic topic = new Topic();
                topic.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split(ExaminationSolutionImporter.SPLIT_REGEX);
                topic.setDuration(Integer.parseInt(lineTokens[0]));
                ArrayList<Student> topicStudentList = new ArrayList<Student>(lineTokens.length - 1);
                for (int j = 1; j < lineTokens.length; ++j) {
                    topicStudentList.add(this.findOrCreateStudent(studentMap, Integer.parseInt(lineTokens[j])));
                }
                topic.setStudentList(topicStudentList);
                topic.setFrontLoadLarge(false);
                topicList.add(topic);
            }
            examination.setTopicList(topicList);
            ArrayList<Student> studentList = new ArrayList<Student>(studentMap.values());
            examination.setStudentList(studentList);
        }

        private Student findOrCreateStudent(Map<Integer, Student> studentMap, int id) {
            Student student = studentMap.get(id);
            if (student == null) {
                student = new Student();
                student.setId(Long.valueOf(id));
                studentMap.put(id, student);
            }
            return student;
        }

        private void readPeriodList(Examination examination) throws IOException {
            int periodSize = this.readHeaderWithNumber("Periods");
            ArrayList<Period> periodList = new ArrayList<Period>(periodSize);
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd:MM:yyyy HH:mm:ss");
            int referenceDayOfYear = -1;
            int referenceYear = -1;
            for (int i = 0; i < periodSize; ++i) {
                int year;
                int dayOfYear;
                Period period = new Period();
                period.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split(ExaminationSolutionImporter.SPLIT_REGEX);
                if (lineTokens.length != 4) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 4 tokens.");
                }
                String startDateTimeString = lineTokens[0] + " " + lineTokens[1];
                period.setStartDateTimeString(startDateTimeString);
                period.setPeriodIndex(i);
                try {
                    calendar.setTime(DATE_FORMAT.parse(startDateTimeString));
                    calendar.get(6);
                    dayOfYear = calendar.get(6);
                    year = calendar.get(1);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Illegal startDateTimeString (" + startDateTimeString + ").", e);
                }
                if (referenceDayOfYear < 0) {
                    referenceDayOfYear = dayOfYear;
                    referenceYear = year;
                }
                if (year != referenceYear) {
                    throw new IllegalStateException("Not yet implemented to handle periods spread over different years...");
                }
                int dayIndex = dayOfYear - referenceDayOfYear;
                if (dayIndex < 0) {
                    throw new IllegalStateException("The periods should be in ascending order.");
                }
                period.setDayIndex(dayIndex);
                period.setDuration(Integer.parseInt(lineTokens[2]));
                period.setPenalty(Integer.parseInt(lineTokens[3]));
                periodList.add(period);
            }
            examination.setPeriodList(periodList);
        }

        private void readRoomList(Examination examination) throws IOException {
            int roomSize = this.readHeaderWithNumber("Rooms");
            ArrayList<Room> roomList = new ArrayList<Room>(roomSize);
            for (int i = 0; i < roomSize; ++i) {
                Room room = new Room();
                room.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split(ExaminationSolutionImporter.SPLIT_REGEX);
                if (lineTokens.length != 2) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 2 tokens.");
                }
                room.setCapacity(Integer.parseInt(lineTokens[0]));
                room.setPenalty(Integer.parseInt(lineTokens[1]));
                roomList.add(room);
            }
            examination.setRoomList(roomList);
        }

        private void readPeriodPenaltyList(Examination examination) throws IOException {
            List<Topic> topicList = examination.getTopicList();
            ArrayList<PeriodPenalty> periodPenaltyList = new ArrayList<PeriodPenalty>();
            String line = this.bufferedReader.readLine();
            int id = 0;
            while (!line.equals("[RoomHardConstraints]")) {
                String[] lineTokens = line.split(ExaminationSolutionImporter.SPLIT_REGEX);
                PeriodPenalty periodPenalty = new PeriodPenalty();
                periodPenalty.setId(Long.valueOf(id));
                if (lineTokens.length != 3) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 3 tokens.");
                }
                Topic leftTopic = topicList.get(Integer.parseInt(lineTokens[0]));
                periodPenalty.setLeftSideTopic(leftTopic);
                PeriodPenaltyType periodPenaltyType = PeriodPenaltyType.valueOf(lineTokens[1]);
                periodPenalty.setPeriodPenaltyType(periodPenaltyType);
                Topic rightTopic = topicList.get(Integer.parseInt(lineTokens[2]));
                periodPenalty.setRightSideTopic(rightTopic);
                if (periodPenaltyType == PeriodPenaltyType.EXAM_COINCIDENCE) {
                    if (!Collections.disjoint(leftTopic.getStudentList(), rightTopic.getStudentList())) {
                        ExaminationSolutionImporter.this.logger.warn("Filtering out periodPenalty (" + periodPenalty + ") because the left and right topic share students.");
                    } else {
                        periodPenaltyList.add(periodPenalty);
                    }
                } else {
                    periodPenaltyList.add(periodPenalty);
                }
                line = this.bufferedReader.readLine();
                ++id;
            }
            examination.setPeriodPenaltyList(periodPenaltyList);
        }

        private void readRoomPenaltyList(Examination examination) throws IOException {
            List<Topic> topicList = examination.getTopicList();
            ArrayList<RoomPenalty> roomPenaltyList = new ArrayList<RoomPenalty>();
            String line = this.bufferedReader.readLine();
            int id = 0;
            while (!line.equals("[InstitutionalWeightings]")) {
                String[] lineTokens = line.split(ExaminationSolutionImporter.SPLIT_REGEX);
                RoomPenalty roomPenalty = new RoomPenalty();
                roomPenalty.setId(Long.valueOf(id));
                if (lineTokens.length != 2) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 3 tokens.");
                }
                roomPenalty.setTopic(topicList.get(Integer.parseInt(lineTokens[0])));
                roomPenalty.setRoomPenaltyType(RoomPenaltyType.valueOf(lineTokens[1]));
                roomPenaltyList.add(roomPenalty);
                line = this.bufferedReader.readLine();
                ++id;
            }
            examination.setRoomPenaltyList(roomPenaltyList);
        }

        private int readHeaderWithNumber(String header) throws IOException {
            String line = this.bufferedReader.readLine();
            if (!line.startsWith("[" + header + ":") || !line.endsWith("]")) {
                throw new IllegalStateException("Read line (" + line + " is not the expected header ([" + header + ":number])");
            }
            return Integer.parseInt(line.substring(header.length() + 2, line.length() - 1));
        }

        private void readInstitutionalWeighting(Examination examination) throws IOException {
            InstitutionParametrization institutionParametrization = new InstitutionParametrization();
            institutionParametrization.setId(0L);
            String[] lineTokens = this.readInstitutionalWeightingProperty("TWOINAROW", 2);
            institutionParametrization.setTwoInARowPenalty(Integer.parseInt(lineTokens[1]));
            lineTokens = this.readInstitutionalWeightingProperty("TWOINADAY", 2);
            institutionParametrization.setTwoInADayPenalty(Integer.parseInt(lineTokens[1]));
            lineTokens = this.readInstitutionalWeightingProperty("PERIODSPREAD", 2);
            institutionParametrization.setPeriodSpreadLength(Integer.parseInt(lineTokens[1]));
            institutionParametrization.setPeriodSpreadPenalty(1);
            lineTokens = this.readInstitutionalWeightingProperty("NONMIXEDDURATIONS", 2);
            institutionParametrization.setMixedDurationPenalty(Integer.parseInt(lineTokens[1]));
            lineTokens = this.readInstitutionalWeightingProperty("FRONTLOAD", 4);
            institutionParametrization.setFrontLoadLargeTopicSize(Integer.parseInt(lineTokens[1]));
            institutionParametrization.setFrontLoadLastPeriodSize(Integer.parseInt(lineTokens[2]));
            institutionParametrization.setFrontLoadPenalty(Integer.parseInt(lineTokens[3]));
            examination.setInstitutionParametrization(institutionParametrization);
        }

        private String[] readInstitutionalWeightingProperty(String property, int propertySize) throws IOException {
            Object[] lineTokens = this.bufferedReader.readLine().split(ExaminationSolutionImporter.SPLIT_REGEX);
            if (!lineTokens[0].equals(property) || lineTokens.length != propertySize) {
                throw new IllegalArgumentException("Read line (" + Arrays.toString(lineTokens) + ") is expected to contain " + propertySize + " tokens and start with " + property + ".");
            }
            return lineTokens;
        }

        private void tagFrontLoadLargeTopics(Examination examination) {
            ArrayList<Topic> sortedTopicList = new ArrayList<Topic>(examination.getTopicList());
            Collections.sort(sortedTopicList, new Comparator<Topic>(){

                @Override
                public int compare(Topic a, Topic b) {
                    return new CompareToBuilder().append(a.getStudentSize(), b.getStudentSize()).append((Object)b.getId(), (Object)a.getId()).toComparison();
                }
            });
            int frontLoadLargeTopicSize = examination.getInstitutionParametrization().getFrontLoadLargeTopicSize();
            if (frontLoadLargeTopicSize == 0) {
                return;
            }
            int minimumTopicId = sortedTopicList.size() - frontLoadLargeTopicSize;
            if (minimumTopicId < 0) {
                ExaminationSolutionImporter.this.logger.warn("The frontLoadLargeTopicSize (" + frontLoadLargeTopicSize + ") is bigger than topicListSize (" + sortedTopicList.size() + "). Tagging all topic as frontLoadLarge...");
                minimumTopicId = 0;
            }
            for (Topic topic : sortedTopicList.subList(minimumTopicId, sortedTopicList.size())) {
                topic.setFrontLoadLarge(true);
            }
        }

        private void tagFrontLoadLastPeriods(Examination examination) {
            List<Period> periodList = examination.getPeriodList();
            int frontLoadLastPeriodSize = examination.getInstitutionParametrization().getFrontLoadLastPeriodSize();
            if (frontLoadLastPeriodSize == 0) {
                return;
            }
            int minimumPeriodId = periodList.size() - frontLoadLastPeriodSize;
            if (minimumPeriodId < 0) {
                ExaminationSolutionImporter.this.logger.warn("The frontLoadLastPeriodSize (" + frontLoadLastPeriodSize + ") is bigger than periodListSize (" + periodList.size() + "). Tagging all periods as frontLoadLast...");
                minimumPeriodId = 0;
            }
            for (Period period : periodList.subList(minimumPeriodId, periodList.size())) {
                period.setFrontLoadLast(true);
            }
        }

        private void createExamList(Examination examination) {
            List<Topic> topicList = examination.getTopicList();
            ArrayList<Exam> examList = new ArrayList<Exam>(topicList.size());
            HashMap<Topic, Exam> topicToExamMap = new HashMap<Topic, Exam>(topicList.size());
            for (Topic topic : topicList) {
                Exam exam = new Exam();
                exam.setId(topic.getId());
                exam.setTopic(topic);
                examList.add(exam);
                topicToExamMap.put(topic, exam);
            }
            for (PeriodPenalty periodPenalty : examination.getPeriodPenaltyList()) {
                if (periodPenalty.getPeriodPenaltyType() == PeriodPenaltyType.EXAM_COINCIDENCE) {
                    Exam leftExam = (Exam)topicToExamMap.get(periodPenalty.getLeftSideTopic());
                    Exam rightExam = (Exam)topicToExamMap.get(periodPenalty.getRightSideTopic());
                    LinkedHashSet<Exam> newCoincidenceExamSet = new LinkedHashSet<Exam>(4);
                    ExamCoincidence leftExamCoincidence = leftExam.getExamCoincidence();
                    if (leftExamCoincidence != null) {
                        newCoincidenceExamSet.addAll(leftExamCoincidence.getCoincidenceExamSet());
                    } else {
                        newCoincidenceExamSet.add(leftExam);
                    }
                    ExamCoincidence rightExamCoincidence = rightExam.getExamCoincidence();
                    if (rightExamCoincidence != null) {
                        newCoincidenceExamSet.addAll(rightExamCoincidence.getCoincidenceExamSet());
                    } else {
                        newCoincidenceExamSet.add(rightExam);
                    }
                    ExamCoincidence newExamCoincidence = new ExamCoincidence(newCoincidenceExamSet);
                    for (Exam exam : newCoincidenceExamSet) {
                        exam.setExamCoincidence(newExamCoincidence);
                    }
                    continue;
                }
                if (periodPenalty.getPeriodPenaltyType() != PeriodPenaltyType.AFTER) continue;
                Exam afterExam = (Exam)topicToExamMap.get(periodPenalty.getLeftSideTopic());
                Exam beforeExam = (Exam)topicToExamMap.get(periodPenalty.getRightSideTopic());
                ExamBefore examBefore = beforeExam.getExamBefore();
                if (examBefore == null) {
                    examBefore = new ExamBefore(new LinkedHashSet<Exam>(2));
                    beforeExam.setExamBefore(examBefore);
                }
                examBefore.getAfterExamSet().add(afterExam);
            }
            examination.setExamList(examList);
        }
    }
}

