/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.value.ValueRange;
import org.optaplanner.core.api.domain.value.ValueRangeType;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.Job;
import org.optaplanner.examples.projectjobscheduling.domain.Project;
import org.optaplanner.examples.projectjobscheduling.domain.solver.NotSourceOrSinkAllocationFilter;
import org.optaplanner.examples.projectjobscheduling.domain.solver.PredecessorsDoneDateUpdatingVariableListener;

@PlanningEntity(movableEntitySelectionFilter=NotSourceOrSinkAllocationFilter.class)
@XStreamAlias(value="PjsAllocation")
public class Allocation
extends AbstractPersistable {
    private Job job;
    private Allocation sourceAllocation;
    private Allocation sinkAllocation;
    private List<Allocation> predecessorAllocationList;
    private List<Allocation> successorAllocationList;
    private ExecutionMode executionMode;
    private Integer delay;
    private Integer predecessorsDoneDate;
    private List<Integer> delayRange;

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Allocation getSourceAllocation() {
        return this.sourceAllocation;
    }

    public void setSourceAllocation(Allocation sourceAllocation) {
        this.sourceAllocation = sourceAllocation;
    }

    public Allocation getSinkAllocation() {
        return this.sinkAllocation;
    }

    public void setSinkAllocation(Allocation sinkAllocation) {
        this.sinkAllocation = sinkAllocation;
    }

    public List<Allocation> getPredecessorAllocationList() {
        return this.predecessorAllocationList;
    }

    public void setPredecessorAllocationList(List<Allocation> predecessorAllocationList) {
        this.predecessorAllocationList = predecessorAllocationList;
    }

    public List<Allocation> getSuccessorAllocationList() {
        return this.successorAllocationList;
    }

    public void setSuccessorAllocationList(List<Allocation> successorAllocationList) {
        this.successorAllocationList = successorAllocationList;
    }

    @PlanningVariable(variableListenerClasses={PredecessorsDoneDateUpdatingVariableListener.class})
    @ValueRange(type=ValueRangeType.FROM_PLANNING_ENTITY_PROPERTY, planningEntityProperty="executionModeRange")
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @PlanningVariable(variableListenerClasses={PredecessorsDoneDateUpdatingVariableListener.class})
    @ValueRange(type=ValueRangeType.FROM_PLANNING_ENTITY_PROPERTY, planningEntityProperty="delayRange")
    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Integer getPredecessorsDoneDate() {
        return this.predecessorsDoneDate;
    }

    public void setPredecessorsDoneDate(Integer predecessorsDoneDate) {
        this.predecessorsDoneDate = predecessorsDoneDate;
    }

    public Integer getStartDate() {
        if (this.predecessorsDoneDate == null || this.delay == null) {
            return null;
        }
        return this.predecessorsDoneDate + this.delay;
    }

    public Integer getEndDate() {
        if (this.predecessorsDoneDate == null || this.delay == null || this.executionMode == null) {
            return null;
        }
        return this.predecessorsDoneDate + this.delay + this.executionMode.getDuration();
    }

    public Project getProject() {
        return this.job.getProject();
    }

    public String getLabel() {
        return "Job " + this.job.getId();
    }

    public List<ExecutionMode> getExecutionModeRange() {
        return this.job.getExecutionModeList();
    }

    public List<Integer> getDelayRange() {
        if (this.delayRange == null) {
            this.delayRange = new ArrayList<Integer>(50);
            for (int i = 0; i < 50; ++i) {
                this.delayRange.add(i);
            }
        }
        return this.delayRange;
    }
}

