/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.travelingtournament.domain.Day;
import org.optaplanner.examples.travelingtournament.domain.Match;
import org.optaplanner.examples.travelingtournament.domain.TravelingTournament;

public class TravelingTournamentPanel
extends SolutionPanel {
    public TravelingTournamentPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    private TravelingTournament getTravelingTournament() {
        return (TravelingTournament)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        DayPanel dayPanel;
        this.removeAll();
        TravelingTournament travelingTournament = (TravelingTournament)solution;
        HashMap<Day, DayPanel> dayPanelMap = new HashMap<Day, DayPanel>();
        for (Day day : travelingTournament.getDayList()) {
            dayPanel = new DayPanel();
            this.add(dayPanel);
            dayPanelMap.put(day, dayPanel);
        }
        for (Match match : travelingTournament.getMatchList()) {
            dayPanel = (DayPanel)dayPanelMap.get(match.getDay());
            dayPanel.addMatch(match);
        }
    }

    private class MatchAction
    extends AbstractAction {
        private Match match;

        public MatchAction(Match match) {
            super(match.toString());
            this.match = match;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Day> dayList = TravelingTournamentPanel.this.getTravelingTournament().getDayList();
            JComboBox<Object> dayListField = new JComboBox<Object>(dayList.toArray());
            dayListField.setSelectedItem(this.match.getDay());
            int result = JOptionPane.showConfirmDialog(TravelingTournamentPanel.this.getRootPane(), dayListField, "Select day", 2);
            if (result == 0) {
                Day toDay = (Day)dayListField.getSelectedItem();
                throw new UnsupportedOperationException();
            }
        }
    }

    private class DayPanel
    extends JPanel {
        public DayPanel() {
            super(new GridLayout(1, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addMatch(Match match) {
            JButton button = new JButton(new MatchAction(match));
            this.add(button);
        }
    }
}

