/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.latitudelongitude.LatitudeLongitudeTranslator;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;
import org.optaplanner.examples.vehiclerouting.domain.VrpDepot;
import org.optaplanner.examples.vehiclerouting.domain.VrpLocation;
import org.optaplanner.examples.vehiclerouting.domain.VrpSchedule;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedSchedule;

public class VehicleRoutingSchedulePainter {
    private static final int TEXT_SIZE = 12;
    private static final int TIME_WINDOW_DIAMETER = 26;
    private static final String IMAGE_PATH_PREFIX = "/org/optaplanner/examples/vehiclerouting/swingui/";
    private ImageIcon depotImageIcon;
    private ImageIcon[] vehicleImageIcons;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private BufferedImage canvas = null;
    private LatitudeLongitudeTranslator translator = null;

    public VehicleRoutingSchedulePainter() {
        this.depotImageIcon = new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/depot.png"));
        this.vehicleImageIcons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleChameleon.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleButter.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleSkyBlue.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehicleChocolate.png")), new ImageIcon(this.getClass().getResource("/org/optaplanner/examples/vehiclerouting/swingui/vehiclePlum.png"))};
        if (this.vehicleImageIcons.length != TangoColorFactory.SEQUENCE_1.length) {
            throw new IllegalStateException("The vehicleImageIcons length (" + this.vehicleImageIcons.length + ") should be equal to the TangoColorFactory.SEQUENCE length (" + TangoColorFactory.SEQUENCE_1.length + ").");
        }
    }

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    public LatitudeLongitudeTranslator getTranslator() {
        return this.translator;
    }

    public void reset(VrpSchedule schedule, Dimension size, ImageObserver imageObserver) {
        this.translator = new LatitudeLongitudeTranslator();
        for (VrpLocation location : schedule.getLocationList()) {
            this.translator.addCoordinates(location.getLatitude(), location.getLongitude());
        }
        int maximumTimeWindowTime = this.determineMaximumTimeWindowTime(schedule);
        double width = size.getWidth();
        double height = size.getHeight();
        this.translator.prepareFor(width, height - 10.0 - 12.0);
        Graphics2D g = this.createCanvas(width, height);
        g.setFont(g.getFont().deriveFont(12.0f));
        g.setStroke(TangoColorFactory.NORMAL_STROKE);
        for (VrpCustomer customer : schedule.getCustomerList()) {
            VrpLocation location = customer.getLocation();
            int x = this.translator.translateLongitudeToX(location.getLongitude());
            int y = this.translator.translateLatitudeToY(location.getLatitude());
            g.setColor(TangoColorFactory.ALUMINIUM_4);
            g.fillRect(x - 1, y - 1, 3, 3);
            String demandString = Integer.toString(customer.getDemand());
            g.drawString(demandString, x - g.getFontMetrics().stringWidth(demandString) / 2, y - 6);
            if (!(customer instanceof VrpTimeWindowedCustomer)) continue;
            VrpTimeWindowedCustomer timeWindowedCustomer = (VrpTimeWindowedCustomer)customer;
            g.setColor(TangoColorFactory.ALUMINIUM_3);
            int circleX = x - 13;
            int circleY = y + 5;
            g.drawOval(circleX, circleY, 26, 26);
            g.fillArc(circleX, circleY, 26, 26, 90 - this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getReadyTime()), this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getReadyTime()) - this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getDueTime()));
            if (timeWindowedCustomer.getArrivalTime() == null) continue;
            if (timeWindowedCustomer.isArrivalAfterDueTime()) {
                g.setColor(TangoColorFactory.SCARLET_2);
            } else if (timeWindowedCustomer.isArrivalBeforeReadyTime()) {
                g.setColor(TangoColorFactory.ORANGE_2);
            } else {
                g.setColor(TangoColorFactory.ALUMINIUM_6);
            }
            g.setStroke(TangoColorFactory.THICK_STROKE);
            int circleCenterY = y + 5 + 13;
            int angle = this.calculateTimeWindowDegree(maximumTimeWindowTime, timeWindowedCustomer.getArrivalTime());
            g.drawLine(x, circleCenterY, x + (int)(Math.sin(Math.toRadians(angle)) * 16.0), circleCenterY - (int)(Math.cos(Math.toRadians(angle)) * 16.0));
            g.setStroke(TangoColorFactory.NORMAL_STROKE);
        }
        g.setColor(TangoColorFactory.ALUMINIUM_3);
        for (VrpDepot depot : schedule.getDepotList()) {
            int x = this.translator.translateLongitudeToX(depot.getLocation().getLongitude());
            int y = this.translator.translateLatitudeToY(depot.getLocation().getLatitude());
            g.fillRect(x - 2, y - 2, 5, 5);
            g.drawImage(this.depotImageIcon.getImage(), x - this.depotImageIcon.getIconWidth() / 2, y - 2 - this.depotImageIcon.getIconHeight(), imageObserver);
        }
        int colorIndex = 0;
        for (VrpVehicle vehicle : schedule.getVehicleList()) {
            int y;
            g.setColor(TangoColorFactory.SEQUENCE_2[colorIndex]);
            VrpCustomer vehicleInfoCustomer = null;
            int longestNonDepotDistance = -1;
            int load = 0;
            for (VrpCustomer customer : schedule.getCustomerList()) {
                if (customer.getPreviousStandstill() == null || customer.getVehicle() != vehicle) continue;
                load += customer.getDemand();
                VrpLocation previousLocation = customer.getPreviousStandstill().getLocation();
                int previousX = this.translator.translateLongitudeToX(previousLocation.getLongitude());
                int previousY = this.translator.translateLatitudeToY(previousLocation.getLatitude());
                VrpLocation location = customer.getLocation();
                int x = this.translator.translateLongitudeToX(location.getLongitude());
                y = this.translator.translateLatitudeToY(location.getLatitude());
                g.drawLine(previousX, previousY, x, y);
                int distance = customer.getDistanceToPreviousStandstill();
                if (customer.getPreviousStandstill() instanceof VrpCustomer) {
                    if (longestNonDepotDistance < distance) {
                        longestNonDepotDistance = distance;
                        vehicleInfoCustomer = customer;
                    }
                } else if (vehicleInfoCustomer == null) {
                    vehicleInfoCustomer = customer;
                }
                if (customer.getNextCustomer() != null) continue;
                VrpLocation vehicleLocation = vehicle.getLocation();
                int vehicleX = this.translator.translateLongitudeToX(vehicleLocation.getLongitude());
                int vehicleY = this.translator.translateLatitudeToY(vehicleLocation.getLatitude());
                g.setStroke(TangoColorFactory.FAT_DASHED_STROKE);
                g.drawLine(x, y, vehicleX, vehicleY);
                g.setStroke(TangoColorFactory.NORMAL_STROKE);
            }
            if (vehicleInfoCustomer != null) {
                if (load > vehicle.getCapacity()) {
                    g.setColor(TangoColorFactory.SCARLET_2);
                }
                VrpLocation previousLocation = vehicleInfoCustomer.getPreviousStandstill().getLocation();
                VrpLocation location = vehicleInfoCustomer.getLocation();
                double longitude = (previousLocation.getLongitude() + location.getLongitude()) / 2.0;
                int x = this.translator.translateLongitudeToX(longitude);
                double latitude = (previousLocation.getLatitude() + location.getLatitude()) / 2.0;
                y = this.translator.translateLatitudeToY(latitude);
                boolean ascending = previousLocation.getLongitude() < location.getLongitude() ^ previousLocation.getLatitude() < location.getLatitude();
                ImageIcon vehicleImageIcon = this.vehicleImageIcons[colorIndex];
                int vehicleInfoHeight = vehicleImageIcon.getIconHeight() + 2 + 12;
                g.drawImage(vehicleImageIcon.getImage(), x + 1, ascending ? y - vehicleInfoHeight - 1 : y + 1, imageObserver);
                g.drawString(load + " / " + vehicle.getCapacity(), x + 1, ascending ? y - 1 : y + vehicleInfoHeight + 1);
            }
            colorIndex = (colorIndex + 1) % TangoColorFactory.SEQUENCE_2.length;
        }
        g.setColor(TangoColorFactory.ALUMINIUM_3);
        g.fillRect(5, (int)height - 12 - 12 - 6, 5, 5);
        g.drawString("Depot", 15, (int)height - 10 - 12);
        String vehiclesSizeString = schedule.getVehicleList().size() + " vehicles";
        g.drawString(vehiclesSizeString, ((int)width - g.getFontMetrics().stringWidth(vehiclesSizeString)) / 2, (int)height - 10 - 12);
        g.setColor(TangoColorFactory.ALUMINIUM_4);
        g.fillRect(6, (int)height - 6 - 6, 3, 3);
        g.drawString(schedule instanceof VrpTimeWindowedSchedule ? "Customer: demand, time window and arrival time" : "Customer: demand", 15, (int)height - 5);
        String customersSizeString = schedule.getCustomerList().size() + " customers";
        g.drawString(customersSizeString, ((int)width - g.getFontMetrics().stringWidth(customersSizeString)) / 2, (int)height - 5);
        g.setColor(TangoColorFactory.SCARLET_2);
        HardSoftScore score = schedule.getScore();
        if (score != null) {
            String totalDistanceString = !score.isFeasible() ? "Not feasible" : this.numberFormat.format(-score.getSoftScore()) + (schedule instanceof VrpTimeWindowedSchedule ? " time" : " fuel");
            g.setFont(g.getFont().deriveFont(1, 24.0f));
            g.drawString(totalDistanceString, (int)width - g.getFontMetrics().stringWidth(totalDistanceString) - 10, (int)height - 10);
        }
    }

    private int determineMaximumTimeWindowTime(VrpSchedule schedule) {
        int timeWindowTime;
        int maximumTimeWindowTime = 0;
        for (VrpDepot depot : schedule.getDepotList()) {
            if (!(depot instanceof VrpTimeWindowedDepot) || (timeWindowTime = ((VrpTimeWindowedDepot)depot).getDueTime()) <= maximumTimeWindowTime) continue;
            maximumTimeWindowTime = timeWindowTime;
        }
        for (VrpCustomer customer : schedule.getCustomerList()) {
            if (!(customer instanceof VrpTimeWindowedCustomer) || (timeWindowTime = ((VrpTimeWindowedCustomer)customer).getDueTime()) <= maximumTimeWindowTime) continue;
            maximumTimeWindowTime = timeWindowTime;
        }
        return maximumTimeWindowTime;
    }

    private int calculateTimeWindowDegree(int maximumTimeWindowTime, int timeWindowTime) {
        return 360 * timeWindowTime / maximumTimeWindowTime;
    }

    public Graphics2D createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g = this.canvas.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }
}

