/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.business;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.event.BestSolutionChangedEvent;
import org.optaplanner.core.impl.event.SolverEventListener;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.business.SolutionFileFilter;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionBusiness {
    private static final ProblemFileComparator FILE_COMPARATOR = new ProblemFileComparator();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolutionDao solutionDao;
    private AbstractSolutionImporter importer;
    private AbstractSolutionExporter exporter;
    private File importDataDir;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private File exportDataDir;
    private volatile Solver solver;
    private ScoreDirector guiScoreDirector;

    public void setSolutionDao(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    public void setImporter(AbstractSolutionImporter importer) {
        this.importer = importer;
    }

    public void setExporter(AbstractSolutionExporter exporter) {
        this.exporter = exporter;
    }

    public File getDataDir() {
        return this.solutionDao.getDataDir();
    }

    public String getDirName() {
        return this.solutionDao.getDirName();
    }

    public boolean hasImporter() {
        return this.importer != null;
    }

    public boolean hasExporter() {
        return this.exporter != null;
    }

    public void updateDataDirs() {
        File dataDir = this.getDataDir();
        if (!dataDir.exists()) {
            throw new IllegalStateException("The directory dataDir (" + dataDir.getAbsolutePath() + ") does not exist." + " The working directory should be set to the directory that contains the data directory." + " This is different in a git clone (optaplanner/optaplanner-examples)" + " and the release zip (examples).");
        }
        if (this.hasImporter()) {
            this.importDataDir = new File(dataDir, "input");
            if (!this.importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + this.importDataDir.getAbsolutePath() + ") does not exist.");
            }
        }
        this.unsolvedDataDir = new File(dataDir, "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist.");
        }
        this.solvedDataDir = new File(dataDir, "solved");
        if (!this.solvedDataDir.exists() && !this.solvedDataDir.mkdir()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        if (this.hasExporter()) {
            this.exportDataDir = new File(dataDir, "output");
            if (!this.exportDataDir.exists() && !this.exportDataDir.mkdir()) {
                throw new IllegalStateException("The directory exportDataDir (" + this.exportDataDir.getAbsolutePath() + ") does not exist and could not be created.");
            }
        }
    }

    public File getImportDataDir() {
        return this.importDataDir;
    }

    public boolean acceptImportFile(File file) {
        return this.importer.acceptInputFile(file);
    }

    public String getImportFileSuffix() {
        return this.importer.getInputFileSuffix();
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public File getExportDataDir() {
        return this.exportDataDir;
    }

    public void setSolver(Solver solver) {
        this.solver = solver;
        ScoreDirectorFactory scoreDirectorFactory = solver.getScoreDirectorFactory();
        this.guiScoreDirector = scoreDirectorFactory.buildScoreDirector();
    }

    public List<File> getUnsolvedFileList() {
        List<File> fileList = this.extractFileList(this.unsolvedDataDir);
        Collections.sort(fileList, FILE_COMPARATOR);
        return fileList;
    }

    public List<File> getSolvedFileList() {
        List<File> fileList = this.extractFileList(this.solvedDataDir);
        Collections.sort(fileList, FILE_COMPARATOR);
        return fileList;
    }

    public List<File> extractFileList(File directory) {
        List<File> fileList = Arrays.asList(directory.listFiles(new SolutionFileFilter(this.solutionDao)));
        for (File subDirectory : directory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)) {
            fileList.addAll(this.extractFileList(subDirectory));
        }
        return fileList;
    }

    public Solution getSolution() {
        return this.guiScoreDirector.getWorkingSolution();
    }

    public void setSolution(Solution solution) {
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public Score getScore() {
        return this.guiScoreDirector.calculateScore();
    }

    public boolean isSolving() {
        return this.solver.isSolving();
    }

    public void registerForBestSolutionChanges(final SolverAndPersistenceFrame solverAndPersistenceFrame) {
        this.solver.addEventListener(new SolverEventListener(){

            public void bestSolutionChanged(BestSolutionChangedEvent event) {
                if (SolutionBusiness.this.solver.isEveryProblemFactChangeProcessed()) {
                    final Solution latestBestSolution = event.getNewBestSolution();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SolutionBusiness.this.guiScoreDirector.setWorkingSolution(latestBestSolution);
                            solverAndPersistenceFrame.bestSolutionChanged();
                        }
                    });
                }
            }
        });
    }

    public boolean isConstraintMatchEnabled() {
        return this.guiScoreDirector.isConstraintMatchEnabled();
    }

    public List<ConstraintMatchTotal> getConstraintMatchTotalList() {
        ArrayList<ConstraintMatchTotal> constraintMatchTotalList = new ArrayList<ConstraintMatchTotal>(this.guiScoreDirector.getConstraintMatchTotals());
        Collections.sort(constraintMatchTotalList);
        return constraintMatchTotalList;
    }

    public void importSolution(File file) {
        Solution solution = this.importer.readSolution(file);
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public void openSolution(File file) {
        Solution solution = this.solutionDao.readSolution(file);
        this.guiScoreDirector.setWorkingSolution(solution);
    }

    public void saveSolution(File file) {
        Solution solution = this.guiScoreDirector.getWorkingSolution();
        this.solutionDao.writeSolution(solution, file);
    }

    public void exportSolution(File file) {
        Solution solution = this.guiScoreDirector.getWorkingSolution();
        this.exporter.writeSolution(solution, file);
    }

    public void doMove(Move move) {
        if (this.solver.isSolving()) {
            this.logger.error("Not doing user move ({}) because the solver is solving.", (Object)move);
            return;
        }
        if (!move.isMoveDoable(this.guiScoreDirector)) {
            this.logger.warn("Not doing user move ({}) because it is not doable.", (Object)move);
            return;
        }
        this.logger.info("Doing user move ({}).", (Object)move);
        move.doMove(this.guiScoreDirector);
    }

    public void doProblemFactChange(ProblemFactChange problemFactChange) {
        if (this.solver.isSolving()) {
            this.solver.addProblemFactChange(problemFactChange);
        } else {
            problemFactChange.doChange(this.guiScoreDirector);
        }
    }

    public Solution solve(Solution planningProblem) {
        this.solver.setPlanningProblem(planningProblem);
        this.solver.solve();
        return this.solver.getBestSolution();
    }

    public void terminateSolvingEarly() {
        this.solver.terminateEarly();
    }
}

