/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.solver.score;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.ExecutionMode;
import org.optaplanner.examples.projectjobscheduling.domain.JobType;
import org.optaplanner.examples.projectjobscheduling.domain.Project;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;
import org.optaplanner.examples.projectjobscheduling.domain.resource.Resource;
import org.optaplanner.examples.projectjobscheduling.solver.score.capacity.NonrenewableResourceCapacityTracker;
import org.optaplanner.examples.projectjobscheduling.solver.score.capacity.RenewableResourceCapacityTracker;
import org.optaplanner.examples.projectjobscheduling.solver.score.capacity.ResourceCapacityTracker;

public class ProjectJobSchedulingIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<Schedule> {
    private Map<Resource, ResourceCapacityTracker> resourceCapacityTrackerMap;
    private Map<Project, Integer> projectDelayMap;
    private Map<Project, Set<Allocation>> allocationsPerProjectMap;
    private int hardScore;
    private int mediumScore;
    private int softScore;
    private int minimalReleaseDate;
    private int maximalEndDate;
    private int totalProjectDelay;

    public void resetWorkingSolution(Schedule schedule) {
        List<Resource> resourceList = schedule.getResourceList();
        this.resourceCapacityTrackerMap = new HashMap<Resource, ResourceCapacityTracker>(resourceList.size());
        for (Resource resource : resourceList) {
            this.resourceCapacityTrackerMap.put(resource, resource.isRenewable() ? new RenewableResourceCapacityTracker(resource) : new NonrenewableResourceCapacityTracker(resource));
        }
        this.hardScore = 0;
        this.mediumScore = 0;
        this.softScore = 0;
        this.totalProjectDelay = 0;
        this.minimalReleaseDate = Integer.MAX_VALUE;
        this.maximalEndDate = 0;
        for (Project p : schedule.getProjectList()) {
            this.minimalReleaseDate = Math.min(p.getReleaseDate(), this.minimalReleaseDate);
        }
        this.projectDelayMap = new HashMap<Project, Integer>();
        this.allocationsPerProjectMap = new HashMap<Project, Set<Allocation>>();
        for (Allocation allocation : schedule.getAllocationList()) {
            this.insert(allocation);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((Allocation)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((Allocation)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((Allocation)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((Allocation)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private int getTotalProjectDelay(Allocation allocation) {
        Project p = allocation.getJob().getProject();
        int previousProjectDelay = this.projectDelayMap.containsKey(p) ? this.projectDelayMap.get(p) : 0;
        this.totalProjectDelay -= previousProjectDelay;
        Allocation sink = allocation.getSinkAllocation();
        Integer endDate = sink.getEndDate();
        if (endDate == null) {
            this.projectDelayMap.put(p, 0);
        } else {
            int delay = endDate - p.getReleaseDate() - p.getCriticalPathDuration();
            this.totalProjectDelay += delay;
            this.projectDelayMap.put(p, delay);
        }
        return this.totalProjectDelay;
    }

    private void insert(Allocation allocation) {
        this.trackAllocation(allocation);
        Integer endDate = allocation.getEndDate();
        if (endDate != null && endDate > this.maximalEndDate) {
            this.maximalEndDate = endDate;
            this.softScore = -(this.maximalEndDate - this.minimalReleaseDate);
        }
        this.mediumScore = -this.getTotalProjectDelay(allocation);
        ExecutionMode executionMode = allocation.getExecutionMode();
        if (executionMode != null && allocation.getJob().getJobType() == JobType.STANDARD) {
            for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
                ResourceCapacityTracker tracker = this.resourceCapacityTrackerMap.get(resourceRequirement.getResource());
                this.hardScore -= tracker.getHardScore();
                tracker.insert(resourceRequirement, allocation);
                this.hardScore += tracker.getHardScore();
            }
        }
    }

    private void trackAllocation(Allocation a) {
        Project p = a.getJob().getProject();
        if (!this.allocationsPerProjectMap.containsKey(p)) {
            this.allocationsPerProjectMap.put(p, new HashSet());
        }
        this.allocationsPerProjectMap.get(p).add(a);
    }

    private int getMaximalEndDate() {
        int max = 0;
        for (Set<Allocation> allocations : this.allocationsPerProjectMap.values()) {
            for (Allocation allocation : allocations) {
                Integer otherEndDate = allocation.getEndDate();
                if (otherEndDate == null) continue;
                max = Math.max(otherEndDate, max);
            }
        }
        return max;
    }

    private void retract(Allocation allocation) {
        this.allocationsPerProjectMap.get(allocation.getJob().getProject()).remove(allocation);
        Integer endDate = allocation.getEndDate();
        if (endDate != null && endDate >= this.maximalEndDate) {
            this.maximalEndDate = this.getMaximalEndDate();
            this.softScore = -(this.maximalEndDate - this.minimalReleaseDate);
        }
        this.mediumScore = -this.getTotalProjectDelay(allocation);
        ExecutionMode executionMode = allocation.getExecutionMode();
        if (executionMode != null && allocation.getJob().getJobType() == JobType.STANDARD) {
            for (ResourceRequirement resourceRequirement : executionMode.getResourceRequirementList()) {
                ResourceCapacityTracker tracker = this.resourceCapacityTrackerMap.get(resourceRequirement.getResource());
                this.hardScore -= tracker.getHardScore();
                tracker.retract(resourceRequirement, allocation);
                this.hardScore += tracker.getHardScore();
            }
        }
    }

    public Score calculateScore() {
        return BendableScore.valueOf((int[])new int[]{this.hardScore}, (int[])new int[]{this.mediumScore, this.softScore});
    }
}

