/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver;

import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;
import org.optaplanner.examples.vehiclerouting.domain.VrpStandstill;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedCustomer;

public class ArrivalTimeUpdatingVariableListener
implements PlanningVariableListener<VrpCustomer> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, VrpCustomer customer) {
        if (customer instanceof VrpTimeWindowedCustomer) {
            this.updateVehicle(scoreDirector, (VrpTimeWindowedCustomer)customer);
        }
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, VrpCustomer customer) {
        if (customer instanceof VrpTimeWindowedCustomer) {
            this.updateVehicle(scoreDirector, (VrpTimeWindowedCustomer)customer);
        }
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, VrpCustomer customer) {
    }

    protected void updateVehicle(ScoreDirector scoreDirector, VrpTimeWindowedCustomer sourceCustomer) {
        VrpTimeWindowedCustomer shadowCustomer;
        VrpStandstill previousStandstill = sourceCustomer.getPreviousStandstill();
        Integer departureTime = previousStandstill instanceof VrpTimeWindowedCustomer ? ((VrpTimeWindowedCustomer)previousStandstill).getDepartureTime() : null;
        Integer arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        for (shadowCustomer = sourceCustomer; shadowCustomer != null && ObjectUtils.notEqual((Object)shadowCustomer.getArrivalTime(), (Object)arrivalTime); shadowCustomer = shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged((Object)shadowCustomer, "arrivalTime");
            shadowCustomer.setArrivalTime(arrivalTime);
            scoreDirector.afterVariableChanged((Object)shadowCustomer, "arrivalTime");
            departureTime = shadowCustomer.getDepartureTime();
            arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        }
    }

    private Integer calculateArrivalTime(VrpTimeWindowedCustomer customer, Integer previousDepartureTime) {
        if (customer == null) {
            return null;
        }
        if (previousDepartureTime == null) {
            return Math.max(customer.getReadyTime(), customer.getDistanceToPreviousStandstill());
        }
        return previousDepartureTime + customer.getDistanceToPreviousStandstill();
    }
}

