/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.vehiclerouting.domain.VrpCustomer;
import org.optaplanner.examples.vehiclerouting.domain.VrpDepot;
import org.optaplanner.examples.vehiclerouting.domain.VrpLocation;
import org.optaplanner.examples.vehiclerouting.domain.VrpSchedule;
import org.optaplanner.examples.vehiclerouting.domain.VrpVehicle;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.VrpTimeWindowedSchedule;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingDao;

public class VehicleRoutingSolutionImporter
extends AbstractTxtSolutionImporter {
    private static final String INPUT_FILE_SUFFIX = ".vrp";

    public static void main(String[] args) {
        new VehicleRoutingSolutionImporter().convertAll();
    }

    public VehicleRoutingSolutionImporter() {
        super(new VehicleRoutingDao());
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new VrpScheduleInputBuilder();
    }

    public class VrpScheduleInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private VrpSchedule schedule;
        private int locationListSize;
        private int vehicleListSize;
        private int capacity;
        private Map<Long, VrpLocation> locationMap;
        private List<VrpDepot> depotList;

        public VrpScheduleInputBuilder() {
            super(VehicleRoutingSolutionImporter.this);
        }

        @Override
        public Solution readSolution() throws IOException {
            String firstLine = this.readStringValue();
            if (firstLine.trim().startsWith("NAME :")) {
                this.schedule = new VrpSchedule();
                this.schedule.setId(0L);
                this.schedule.setName(this.removePrefixSuffixFromLine(firstLine, "NAME :", ""));
                this.readBasicSolution();
            }
            if (this.splitBySpace(firstLine).length == 3) {
                this.schedule = new VrpSchedule();
                this.schedule.setId(0L);
                String[] tokens = this.splitBySpace(firstLine, 3);
                this.locationListSize = Integer.parseInt(tokens[0]);
                this.vehicleListSize = Integer.parseInt(tokens[1]);
                this.capacity = Integer.parseInt(tokens[2]);
                this.readAlternativeBasicSolution();
            } else {
                this.schedule = new VrpTimeWindowedSchedule();
                this.schedule.setId(0L);
                this.schedule.setName(firstLine);
                this.readTimeWindowedSolution();
            }
            BigInteger possibleSolutionSize = this.factorial(this.schedule.getLocationList().size() - 1);
            String flooredPossibleSolutionSize = "10^" + (possibleSolutionSize.toString().length() - 1);
            VehicleRoutingSolutionImporter.this.logger.info("VrpSchedule {} has {} depots, {} vehicles and {} customers with a search space of {}.", new Object[]{this.getInputId(), this.schedule.getDepotList().size(), this.schedule.getVehicleList().size(), this.schedule.getCustomerList().size(), flooredPossibleSolutionSize});
            return this.schedule;
        }

        public void readBasicSolution() throws IOException {
            this.readBasicHeaders();
            this.readBasicLocationList();
            this.readBasicCustomerList();
            this.readBasicDepotList();
            this.createBasicVehicleList();
            this.readConstantLine("EOF");
        }

        private void readBasicHeaders() throws IOException {
            this.readUntilConstantLine("TYPE : CVRP");
            this.locationListSize = this.readIntegerValue("DIMENSION :");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE :");
            if (!edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
            this.capacity = this.readIntegerValue("CAPACITY :");
        }

        private void readBasicLocationList() throws IOException {
            this.readConstantLine("NODE_COORD_SECTION");
            ArrayList<VrpLocation> locationList = new ArrayList<VrpLocation>(this.locationListSize);
            this.locationMap = new HashMap<Long, VrpLocation>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line.trim().replaceAll(" +", " "), 3);
                VrpLocation location = new VrpLocation();
                location.setId(Long.parseLong(lineTokens[0]));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                this.locationMap.put(location.getId(), location);
            }
            this.schedule.setLocationList(locationList);
        }

        private void readBasicCustomerList() throws IOException {
            this.readConstantLine("DEMAND_SECTION");
            ArrayList<VrpCustomer> customerList = new ArrayList<VrpCustomer>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line.trim().replaceAll(" +", " "), 2);
                VrpCustomer customer = new VrpCustomer();
                long id = Long.parseLong(lineTokens[0]);
                customer.setId(id);
                VrpLocation location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The customer with id (" + id + ") has no location (" + location + ").");
                }
                customer.setLocation(location);
                int demand = Integer.parseInt(lineTokens[1]);
                customer.setDemand(demand);
                if (demand == 0) continue;
                customerList.add(customer);
            }
            this.schedule.setCustomerList(customerList);
        }

        private void readBasicDepotList() throws IOException {
            this.readConstantLine("DEPOT_SECTION");
            this.depotList = new ArrayList<VrpDepot>(this.locationListSize);
            long id = this.readLongValue();
            while (id != -1L) {
                VrpDepot depot = new VrpDepot();
                depot.setId(id);
                VrpLocation location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The depot with id (" + id + ") has no location (" + location + ").");
                }
                depot.setLocation(location);
                this.depotList.add(depot);
                id = this.readLongValue();
            }
            this.schedule.setDepotList(this.depotList);
        }

        private void createBasicVehicleList() throws IOException {
            String inputFileName = this.inputFile.getName();
            if (inputFileName.toLowerCase().startsWith("demo")) {
                this.vehicleListSize = this.readIntegerValue("VEHICLES :");
            } else {
                String inputFileNameRegex = "^.+\\-k(\\d+)\\.vrp$";
                if (!inputFileName.matches(inputFileNameRegex)) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") does not match the inputFileNameRegex (" + inputFileNameRegex + ").");
                }
                String vehicleListSizeString = inputFileName.replaceAll(inputFileNameRegex, "$1");
                try {
                    this.vehicleListSize = Integer.parseInt(vehicleListSizeString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") has a vehicleListSizeString (" + vehicleListSizeString + ") that is not a number.", e);
                }
            }
            this.createVehicleList();
        }

        private void createVehicleList() {
            ArrayList<VrpVehicle> vehicleList = new ArrayList<VrpVehicle>(this.vehicleListSize);
            long id = 0L;
            for (int i = 0; i < this.vehicleListSize; ++i) {
                VrpVehicle vehicle = new VrpVehicle();
                vehicle.setId(id);
                ++id;
                vehicle.setCapacity(this.capacity);
                vehicle.setDepot(this.depotList.get(0));
                vehicleList.add(vehicle);
            }
            this.schedule.setVehicleList(vehicleList);
        }

        public void readAlternativeBasicSolution() throws IOException {
            ArrayList<VrpLocation> locationList = new ArrayList<VrpLocation>(this.locationListSize);
            this.depotList = new ArrayList<VrpDepot>(1);
            ArrayList<VrpCustomer> customerList = new ArrayList<VrpCustomer>(this.locationListSize);
            this.locationMap = new HashMap<Long, VrpLocation>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpace(line.trim().replaceAll(" +", " "), 3);
                VrpLocation location = new VrpLocation();
                location.setId(Long.valueOf(i));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                if (i == 0) {
                    VrpDepot depot = new VrpDepot();
                    depot.setId(Long.valueOf(i));
                    depot.setLocation(location);
                    this.depotList.add(depot);
                    continue;
                }
                VrpCustomer customer = new VrpCustomer();
                customer.setId(Long.valueOf(i));
                customer.setLocation(location);
                int demand = Integer.parseInt(lineTokens[0]);
                customer.setDemand(demand);
                if (demand == 0) continue;
                customerList.add(customer);
            }
            this.schedule.setLocationList(locationList);
            this.schedule.setDepotList(this.depotList);
            this.schedule.setCustomerList(customerList);
            this.createVehicleList();
        }

        public void readTimeWindowedSolution() throws IOException {
            this.readTimeWindowedHeaders();
            this.readTimeWindowedDepotAndCustomers();
            this.createVehicleList();
        }

        private void readTimeWindowedHeaders() throws IOException {
            this.readEmptyLine();
            this.readConstantLine("VEHICLE");
            this.readConstantLine("NUMBER     CAPACITY");
            String[] lineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 2);
            this.vehicleListSize = Integer.parseInt(lineTokens[0]);
            this.capacity = Integer.parseInt(lineTokens[1]);
            this.readEmptyLine();
            this.readConstantLine("CUSTOMER");
            this.readRegexConstantLine("CUST\\s+NO\\.\\s+XCOORD\\.\\s+YCOORD\\.\\s+DEMAND\\s+READY\\s+TIME\\s+DUE\\s+DATE\\s+SERVICE\\s+TIME");
            this.readEmptyLine();
        }

        private void readTimeWindowedDepotAndCustomers() throws IOException {
            String line = this.bufferedReader.readLine();
            int locationListSizeEstimation = 25;
            ArrayList<VrpLocation> locationList = new ArrayList<VrpLocation>(locationListSizeEstimation);
            this.depotList = new ArrayList<VrpDepot>(1);
            ArrayList<VrpCustomer> customerList = new ArrayList<VrpCustomer>(locationListSizeEstimation);
            boolean first = true;
            while (line != null && !line.trim().isEmpty()) {
                int demand;
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 7);
                long id = Long.parseLong(lineTokens[0]);
                VrpLocation location = new VrpLocation();
                location.setId(id);
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                locationList.add(location);
                if (first) {
                    VrpTimeWindowedDepot depot = new VrpTimeWindowedDepot();
                    depot.setId(id);
                    depot.setLocation(location);
                    demand = Integer.parseInt(lineTokens[3]);
                    if (demand != 0) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a demand (" + demand + ").");
                    }
                    depot.setReadyTime(Integer.parseInt(lineTokens[4]));
                    depot.setDueTime(Integer.parseInt(lineTokens[5]));
                    int serviceDuration = Integer.parseInt(lineTokens[6]);
                    if (serviceDuration != 0) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a serviceDuration (" + serviceDuration + ").");
                    }
                    this.depotList.add(depot);
                    first = false;
                } else {
                    VrpTimeWindowedCustomer customer = new VrpTimeWindowedCustomer();
                    customer.setId(id);
                    customer.setLocation(location);
                    demand = Integer.parseInt(lineTokens[3]);
                    customer.setDemand(demand);
                    customer.setReadyTime(Integer.parseInt(lineTokens[4]));
                    customer.setDueTime(Integer.parseInt(lineTokens[5]));
                    customer.setServiceDuration(Integer.parseInt(lineTokens[6]));
                    if (demand != 0) {
                        customerList.add(customer);
                    }
                }
                line = this.bufferedReader.readLine();
            }
            this.schedule.setLocationList(locationList);
            this.schedule.setDepotList(this.depotList);
            this.schedule.setCustomerList(customerList);
        }
    }
}

