/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.solver.LectureDifficultyWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.solver.PeriodStrengthWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.solver.RoomStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=LectureDifficultyWeightFactory.class)
@XStreamAlias(value="Lecture")
public class Lecture
extends AbstractPersistable {
    private Course course;
    private int lectureIndexInCourse;
    private Period period;
    private Room room;

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public int getLectureIndexInCourse() {
        return this.lectureIndexInCourse;
    }

    public void setLectureIndexInCourse(int lectureIndexInCourse) {
        this.lectureIndexInCourse = lectureIndexInCourse;
    }

    @PlanningVariable(valueRangeProviderRefs={"periodRange"}, strengthWeightFactoryClass=PeriodStrengthWeightFactory.class)
    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"}, strengthWeightFactoryClass=RoomStrengthWeightFactory.class)
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public int getStudentSize() {
        return this.course.getStudentSize();
    }

    public List<Curriculum> getCurriculumList() {
        return this.course.getCurriculumList();
    }

    public Day getDay() {
        if (this.period == null) {
            return null;
        }
        return this.period.getDay();
    }

    public int getTimeslotIndex() {
        if (this.period == null) {
            return Integer.MIN_VALUE;
        }
        return this.period.getTimeslot().getTimeslotIndex();
    }

    public String getLabel() {
        return this.course + "-" + this.lectureIndexInCourse;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Lecture) {
            Lecture other = (Lecture)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.course, (Object)other.course).append((Object)this.period, (Object)other.period).append((Object)this.room, (Object)other.room).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.course).append((Object)this.period).append((Object)this.room).toHashCode();
    }

    @Override
    public String toString() {
        return this.course + "-" + this.lectureIndexInCourse + " @ " + this.period + " + " + this.room;
    }
}

