/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.app;

import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingDao;
import org.optaplanner.examples.cloudbalancing.swingui.CloudBalancingPanel;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.common.swingui.SolutionPanel;

public class CloudBalancingApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "/org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml";

    public static void main(String[] args) {
        CloudBalancingApp.prepareSwingEnvironment();
        new CloudBalancingApp().init();
    }

    public CloudBalancingApp() {
        super("Cloud balancing", "Assign processes to computers.\n\nEach computer must have enough hardware to run all of it's processes.\nEach used computer inflicts a maintenance cost.", "/org/optaplanner/examples/cloudbalancing/swingui/cloudBalancingLogo.png");
    }

    @Override
    protected Solver createSolver() {
        XmlSolverFactory solverFactory = new XmlSolverFactory(SOLVER_CONFIG);
        return solverFactory.buildSolver();
    }

    @Override
    protected SolutionPanel createSolutionPanel() {
        return new CloudBalancingPanel();
    }

    @Override
    protected SolutionDao createSolutionDao() {
        return new CloudBalancingDao();
    }
}

