/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractXmlSolutionExporter
extends AbstractSolutionExporter {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = "xml";

    protected AbstractXmlSolutionExporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    @Override
    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public abstract XmlOutputBuilder createXmlOutputBuilder();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeSolution(Solution solution, File outputFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            Document document = new Document();
            XmlOutputBuilder xmlOutputBuilder = this.createXmlOutputBuilder();
            xmlOutputBuilder.setDocument(document);
            xmlOutputBuilder.setSolution(solution);
            xmlOutputBuilder.writeSolution();
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(document, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not write the file (" + outputFile.getName() + ").", e);
                catch (JDOMException e2) {
                    throw new IllegalArgumentException("Could not format the XML file (" + outputFile.getName() + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        this.logger.info("Exported: {}", (Object)outputFile);
    }

    public static abstract class XmlOutputBuilder
    extends AbstractSolutionExporter.OutputBuilder {
        protected Document document;

        public void setDocument(Document document) {
            this.document = document;
        }

        public abstract void setSolution(Solution var1);

        public abstract void writeSolution() throws IOException, JDOMException;
    }
}

