/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.manners2009.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.manners2009.domain.Guest;
import org.optaplanner.examples.manners2009.domain.Job;
import org.optaplanner.examples.manners2009.domain.JobType;
import org.optaplanner.examples.manners2009.domain.Seat;
import org.optaplanner.examples.manners2009.domain.Table;

@PlanningEntity
@XStreamAlias(value="SeatDesignation")
public class SeatDesignation
extends AbstractPersistable {
    private Guest guest;
    private Seat seat;

    public Guest getGuest() {
        return this.guest;
    }

    public void setGuest(Guest guest) {
        this.guest = guest;
    }

    @PlanningVariable(valueRangeProviderRefs={"seatRange"})
    public Seat getSeat() {
        return this.seat;
    }

    public void setSeat(Seat seat) {
        this.seat = seat;
    }

    public Job getGuestJob() {
        return this.getGuest().getJob();
    }

    public JobType getGuestJobType() {
        return this.getGuest().getJob().getJobType();
    }

    public Table getSeatTable() {
        if (this.seat == null) {
            return null;
        }
        return this.seat.getTable();
    }

    @Override
    public String toString() {
        return this.guest + " @ " + this.seat;
    }
}

