/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class EmployeeChangeMove
implements Move {
    private ShiftAssignment shiftAssignment;
    private Employee toEmployee;

    public EmployeeChangeMove(ShiftAssignment shiftAssignment, Employee toEmployee) {
        this.shiftAssignment = shiftAssignment;
        this.toEmployee = toEmployee;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.shiftAssignment.getEmployee(), (Object)this.toEmployee);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new EmployeeChangeMove(this.shiftAssignment, this.shiftAssignment.getEmployee());
    }

    public void doMove(ScoreDirector scoreDirector) {
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.shiftAssignment, this.toEmployee);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.shiftAssignment);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toEmployee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeChangeMove) {
            EmployeeChangeMove other = (EmployeeChangeMove)o;
            return new EqualsBuilder().append((Object)this.shiftAssignment, (Object)other.shiftAssignment).append((Object)this.toEmployee, (Object)other.toEmployee).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.shiftAssignment).append((Object)this.toEmployee).toHashCode();
    }

    public String toString() {
        return this.shiftAssignment + " => " + this.toEmployee;
    }
}

