/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tsp.domain.City;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.solver.LatitudeVisitDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=LatitudeVisitDifficultyComparator.class)
@XStreamAlias(value="Visit")
public class Visit
extends AbstractPersistable
implements Standstill {
    private City city;
    private Standstill previousStandstill;

    @Override
    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    @PlanningVariable(valueRangeProviderRefs={"domicileRange", "visitRange"}, graphType=PlanningVariableGraphType.CHAINED)
    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    public long getDistanceToPreviousStandstill() {
        if (this.previousStandstill == null) {
            return 0L;
        }
        return this.getDistanceTo(this.previousStandstill);
    }

    public long getDistanceTo(Standstill standstill) {
        return this.city.getDistance(standstill.getCity());
    }

    @Override
    public String toString() {
        return this.city + "(after " + (this.previousStandstill == null ? "null" : this.previousStandstill.getCity()) + ")";
    }
}

