/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.solver.score;

import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudBalancingEasyScoreCalculator
implements EasyScoreCalculator<CloudBalance> {
    public HardSoftScore calculateScore(CloudBalance cloudBalance) {
        int hardScore = 0;
        int softScore = 0;
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            int networkBandwidthAvailable;
            int memoryAvailable;
            int cpuPowerUsage = 0;
            int memoryUsage = 0;
            int networkBandwidthUsage = 0;
            boolean used = false;
            for (CloudProcess process : cloudBalance.getProcessList()) {
                if (!computer.equals(process.getComputer())) continue;
                cpuPowerUsage += process.getRequiredCpuPower();
                memoryUsage += process.getRequiredMemory();
                networkBandwidthUsage += process.getRequiredNetworkBandwidth();
                used = true;
            }
            int cpuPowerAvailable = computer.getCpuPower() - cpuPowerUsage;
            if (cpuPowerAvailable < 0) {
                hardScore += cpuPowerAvailable;
            }
            if ((memoryAvailable = computer.getMemory() - memoryUsage) < 0) {
                hardScore += memoryAvailable;
            }
            if ((networkBandwidthAvailable = computer.getNetworkBandwidth() - networkBandwidthUsage) < 0) {
                hardScore += networkBandwidthAvailable;
            }
            if (!used) continue;
            softScore -= computer.getCost();
        }
        return HardSoftScore.valueOf((int)hardScore, (int)softScore);
    }
}

