/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.machinereassignment.domain.MrLocation;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrNeighborhood;
import org.optaplanner.examples.machinereassignment.domain.MrProcess;
import org.optaplanner.examples.machinereassignment.domain.MrResource;
import org.optaplanner.examples.machinereassignment.domain.MrService;
import org.optaplanner.examples.machinereassignment.domain.solver.MrProcessAssignmentDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=MrProcessAssignmentDifficultyComparator.class)
@XStreamAlias(value="MrProcessAssignment")
public class MrProcessAssignment
extends AbstractPersistable {
    private MrProcess process;
    private MrMachine originalMachine;
    private MrMachine machine;

    public MrProcess getProcess() {
        return this.process;
    }

    public void setProcess(MrProcess process) {
        this.process = process;
    }

    public MrMachine getOriginalMachine() {
        return this.originalMachine;
    }

    public void setOriginalMachine(MrMachine originalMachine) {
        this.originalMachine = originalMachine;
    }

    @PlanningVariable(valueRangeProviderRefs={"machineRange"})
    public MrMachine getMachine() {
        return this.machine;
    }

    public void setMachine(MrMachine machine) {
        this.machine = machine;
    }

    public MrService getService() {
        return this.process.getService();
    }

    public boolean isMoved() {
        return !ObjectUtils.equals((Object)this.originalMachine, (Object)this.machine);
    }

    public int getProcessMoveCost() {
        return this.process.getMoveCost();
    }

    public int getMachineMoveCost() {
        return this.machine == null || this.originalMachine == null ? 0 : this.originalMachine.getMoveCostTo(this.machine);
    }

    public MrNeighborhood getNeighborhood() {
        return this.machine == null ? null : this.machine.getNeighborhood();
    }

    public MrLocation getLocation() {
        return this.machine == null ? null : this.machine.getLocation();
    }

    public long getUsage(MrResource resource) {
        return this.process.getUsage(resource);
    }

    public String getLabel() {
        return "Process " + this.getId();
    }

    @Override
    public String toString() {
        return this.process + " @ " + this.machine;
    }
}

