/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver.ArrivalTimeUpdatingVariableListener;

@PlanningEntity
@XStreamAlias(value="VrpTimeWindowedCustomer")
public class TimeWindowedCustomer
extends Customer {
    private int readyTime;
    private int dueTime;
    private int serviceDuration;
    private Integer arrivalTime;

    public int getReadyTime() {
        return this.readyTime;
    }

    public void setReadyTime(int readyTime) {
        this.readyTime = readyTime;
    }

    public int getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(int dueTime) {
        this.dueTime = dueTime;
    }

    public int getServiceDuration() {
        return this.serviceDuration;
    }

    public void setServiceDuration(int serviceDuration) {
        this.serviceDuration = serviceDuration;
    }

    @CustomShadowVariable(variableListenerClass=ArrivalTimeUpdatingVariableListener.class, sources={@CustomShadowVariable.Source(variableName="previousStandstill")})
    public Integer getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(Integer arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public Integer getDepartureTime() {
        if (this.arrivalTime == null) {
            return null;
        }
        return Math.max(this.arrivalTime, this.readyTime) + this.serviceDuration;
    }

    public boolean isArrivalBeforeReadyTime() {
        return this.arrivalTime != null && this.arrivalTime < this.readyTime;
    }

    public boolean isArrivalAfterDueTime() {
        return this.arrivalTime != null && this.dueTime < this.arrivalTime;
    }

    @Override
    public TimeWindowedCustomer getNextCustomer() {
        return (TimeWindowedCustomer)super.getNextCustomer();
    }

    public int getTimeWindowGapTo(TimeWindowedCustomer other) {
        int latestDepartureTime = this.dueTime + this.serviceDuration;
        int otherLatestDepartureTime = other.getDueTime() + other.getServiceDuration();
        if (latestDepartureTime < other.getReadyTime()) {
            return other.getReadyTime() - latestDepartureTime;
        }
        if (otherLatestDepartureTime < this.readyTime) {
            return this.readyTime - otherLatestDepartureTime;
        }
        return 0;
    }
}

