/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.move;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;

public class InvestmentQuantityTransferMove
extends AbstractMove {
    private final AssetClassAllocation fromAssetClassAllocation;
    private final AssetClassAllocation toAssetClassAllocation;
    private final long transferMillis;

    public InvestmentQuantityTransferMove(AssetClassAllocation fromAssetClassAllocation, AssetClassAllocation toAssetClassAllocation, long transferMillis) {
        this.fromAssetClassAllocation = fromAssetClassAllocation;
        this.toAssetClassAllocation = toAssetClassAllocation;
        this.transferMillis = transferMillis;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return true;
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new InvestmentQuantityTransferMove(this.toAssetClassAllocation, this.fromAssetClassAllocation, this.transferMillis);
    }

    public void doMove(ScoreDirector scoreDirector) {
        scoreDirector.beforeVariableChanged((Object)this.fromAssetClassAllocation, "quantityMillis");
        this.fromAssetClassAllocation.setQuantityMillis(this.fromAssetClassAllocation.getQuantityMillis() - this.transferMillis);
        scoreDirector.afterVariableChanged((Object)this.fromAssetClassAllocation, "quantityMillis");
        scoreDirector.beforeVariableChanged((Object)this.toAssetClassAllocation, "quantityMillis");
        this.toAssetClassAllocation.setQuantityMillis(this.toAssetClassAllocation.getQuantityMillis() + this.transferMillis);
        scoreDirector.afterVariableChanged((Object)this.toAssetClassAllocation, "quantityMillis");
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.fromAssetClassAllocation, this.toAssetClassAllocation);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.emptyList();
    }

    public String toString() {
        long fromQuantity = this.fromAssetClassAllocation.getQuantityMillis();
        long toQuantity = this.toAssetClassAllocation.getQuantityMillis();
        return "[" + this.fromAssetClassAllocation + " {" + fromQuantity + "->" + (fromQuantity - this.transferMillis) + "}, " + this.toAssetClassAllocation + " {" + toQuantity + "->" + (toQuantity + this.transferMillis) + "}]";
    }
}

