/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractXlsxSolutionImporter
extends AbstractSolutionImporter {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = "xlsx";

    protected AbstractXlsxSolutionImporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    protected AbstractXlsxSolutionImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract XslxInputBuilder createXslxInputBuilder();

    @Override
    public Solution readSolution(File inputFile) {
        Solution solution;
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            XslxInputBuilder xlsxInputBuilder = this.createXslxInputBuilder();
            xlsxInputBuilder.setInputFile(inputFile);
            xlsxInputBuilder.setWorkbook(workbook);
            try {
                solution = xlsxInputBuilder.readSolution();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Exception in inputFile (" + inputFile + ")", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Exception in inputFile (" + inputFile + ")", e);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        this.logger.info("Imported: {}", (Object)inputFile);
        return solution;
    }

    public static abstract class XslxInputBuilder
    extends AbstractSolutionImporter.InputBuilder {
        protected File inputFile;
        protected XSSFWorkbook workbook;

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public void setWorkbook(XSSFWorkbook document) {
            this.workbook = document;
        }

        public abstract Solution readSolution() throws IOException;

        public String getInputId() {
            return FilenameUtils.getBaseName((String)this.inputFile.getPath());
        }

        protected XSSFSheet readSheet(int index, String name) {
            XSSFSheet sheet = this.workbook.getSheetAt(index);
            if (!sheet.getSheetName().equals(name)) {
                throw new IllegalArgumentException("The sheet (" + sheet.getSheetName() + ") at index (" + index + ") is expected to have another name (" + name + ")");
            }
            return sheet;
        }

        protected void assertCellConstant(Cell cell, String constant) {
            if (!constant.equals(cell.getStringCellValue())) {
                throw new IllegalArgumentException("The cell (" + cell.getRow().getRowNum() + "," + cell.getColumnIndex() + ") with value (" + cell.getStringCellValue() + ") is expected to have the constant (" + constant + ")");
            }
        }

        protected long readLongCell(Cell cell) {
            long l;
            double d = cell.getNumericCellValue();
            if (d - (double)(l = (long)d) != 0.0) {
                throw new IllegalArgumentException("The keyCell (" + cell.getRow().getRowNum() + "," + cell.getColumnIndex() + ") with value (" + d + ") is expected to be a long.");
            }
            return l;
        }

        protected double readDoubleCell(Cell cell) {
            return cell.getNumericCellValue();
        }

        protected String readStringCell(Cell cell) {
            return cell.getStringCellValue();
        }

        protected String readStringParameter(Row row, String key) {
            Cell keyCell = row.getCell(0);
            if (!key.equals(keyCell.getStringCellValue())) {
                throw new IllegalArgumentException("The keyCell (" + keyCell.getRow().getRowNum() + "," + keyCell.getColumnIndex() + ") with value (" + keyCell.getStringCellValue() + ") is expected to have the key (" + key + ")");
            }
            Cell valueCell = row.getCell(1);
            return valueCell.getStringCellValue();
        }

        protected double readDoubleParameter(Row row, String key) {
            Cell keyCell = row.getCell(0);
            if (!key.equals(keyCell.getStringCellValue())) {
                throw new IllegalArgumentException("The keyCell (" + keyCell.getRow().getRowNum() + "," + keyCell.getColumnIndex() + ") with value (" + keyCell.getStringCellValue() + ") is expected to have the key (" + key + ")");
            }
            Cell valueCell = row.getCell(1);
            return valueCell.getNumericCellValue();
        }
    }
}

