/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

public class CloudComputerChangeMove
extends AbstractMove {
    private CloudProcess cloudProcess;
    private CloudComputer toCloudComputer;

    public CloudComputerChangeMove(CloudProcess cloudProcess, CloudComputer toCloudComputer) {
        this.cloudProcess = cloudProcess;
        this.toCloudComputer = toCloudComputer;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.cloudProcess.getComputer(), (Object)this.toCloudComputer);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new CloudComputerChangeMove(this.cloudProcess, this.cloudProcess.getComputer());
    }

    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        CloudBalancingMoveHelper.moveCloudComputer(scoreDirector, this.cloudProcess, this.toCloudComputer);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.cloudProcess);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toCloudComputer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudComputerChangeMove) {
            CloudComputerChangeMove other = (CloudComputerChangeMove)((Object)o);
            return new EqualsBuilder().append((Object)this.cloudProcess, (Object)other.cloudProcess).append((Object)this.toCloudComputer, (Object)other.toCloudComputer).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cloudProcess).append((Object)this.toCloudComputer).toHashCode();
    }

    public String toString() {
        return this.cloudProcess + " {" + this.cloudProcess.getComputer() + " -> " + this.toCloudComputer + "}";
    }
}

