/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.persistence;

import java.io.IOException;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.curriculumcourse.domain.CourseSchedule;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.persistence.CurriculumCourseDao;

public class CurriculumCourseExporter
extends AbstractTxtSolutionExporter {
    private static final String OUTPUT_FILE_SUFFIX = "sol";

    public static void main(String[] args) {
        new CurriculumCourseExporter().convertAll();
    }

    public CurriculumCourseExporter() {
        super(new CurriculumCourseDao());
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new CurriculumCourseOutputBuilder();
    }

    public static class CurriculumCourseOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private CourseSchedule schedule;

        @Override
        public void setSolution(Solution solution) {
            this.schedule = (CourseSchedule)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            for (Lecture lecture : this.schedule.getLectureList()) {
                this.bufferedWriter.write(lecture.getCourse().getCode() + " r" + lecture.getRoom().getCode() + " " + lecture.getPeriod().getDay().getDayIndex() + " " + lecture.getPeriod().getTimeslot().getTimeslotIndex() + "\r\n");
            }
        }
    }
}

