/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.solution.initializer;

import org.optaplanner.core.impl.phase.custom.AbstractCustomPhaseCommand;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvestmentAllocationSolutionInitializer
extends AbstractCustomPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        InvestmentSolution solution = (InvestmentSolution)scoreDirector.getWorkingSolution();
        this.distributeQuantityEvenly(scoreDirector, solution);
    }

    private void distributeQuantityEvenly(ScoreDirector scoreDirector, InvestmentSolution solution) {
        long budget = 1000L;
        int size = solution.getAssetClassAllocationList().size();
        long budgetPerAllocation = budget / (long)size;
        long remainder = budget % (long)size;
        for (AssetClassAllocation allocation : solution.getAssetClassAllocationList()) {
            long quantityMillis = budgetPerAllocation;
            if (remainder > 0L) {
                --remainder;
                ++quantityMillis;
            }
            scoreDirector.beforeVariableChanged((Object)allocation, "quantityMillis");
            allocation.setQuantityMillis(quantityMillis);
            scoreDirector.afterVariableChanged((Object)allocation, "quantityMillis");
            scoreDirector.triggerVariableListeners();
        }
    }
}

