/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Course;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Day;
import org.optaplanner.examples.curriculumcourse.domain.Period;
import org.optaplanner.examples.curriculumcourse.domain.Room;
import org.optaplanner.examples.curriculumcourse.domain.Teacher;
import org.optaplanner.examples.curriculumcourse.domain.solver.LectureDifficultyWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.solver.MovableLectureSelectionFilter;
import org.optaplanner.examples.curriculumcourse.domain.solver.PeriodStrengthWeightFactory;
import org.optaplanner.examples.curriculumcourse.domain.solver.RoomStrengthWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=LectureDifficultyWeightFactory.class, movableEntitySelectionFilter=MovableLectureSelectionFilter.class)
@XStreamAlias(value="Lecture")
public class Lecture
extends AbstractPersistable {
    private Course course;
    private int lectureIndexInCourse;
    private boolean locked;
    private Period period;
    private Room room;

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public int getLectureIndexInCourse() {
        return this.lectureIndexInCourse;
    }

    public void setLectureIndexInCourse(int lectureIndexInCourse) {
        this.lectureIndexInCourse = lectureIndexInCourse;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @PlanningVariable(valueRangeProviderRefs={"periodRange"}, strengthWeightFactoryClass=PeriodStrengthWeightFactory.class)
    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    @PlanningVariable(valueRangeProviderRefs={"roomRange"}, strengthWeightFactoryClass=RoomStrengthWeightFactory.class)
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public Teacher getTeacher() {
        return this.course.getTeacher();
    }

    public int getStudentSize() {
        return this.course.getStudentSize();
    }

    public List<Curriculum> getCurriculumList() {
        return this.course.getCurriculumList();
    }

    public Day getDay() {
        if (this.period == null) {
            return null;
        }
        return this.period.getDay();
    }

    public int getTimeslotIndex() {
        if (this.period == null) {
            return Integer.MIN_VALUE;
        }
        return this.period.getTimeslot().getTimeslotIndex();
    }

    public String getLabel() {
        return this.course.getCode() + "-" + this.lectureIndexInCourse;
    }

    @Override
    public String toString() {
        return this.course + "-" + this.lectureIndexInCourse;
    }
}

