/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.NurseRosterParametrization;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.swingui.EmployeePanel;

public class NurseRosteringPanel
extends SolutionPanel<NurseRoster> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/nurserostering/swingui/nurseRosteringLogo.png";
    private final ImageIcon employeeIcon = new ImageIcon(this.getClass().getResource("employee.png"));
    private final ImageIcon deleteEmployeeIcon = new ImageIcon(this.getClass().getResource("deleteEmployee.png"));
    private JPanel employeeListPanel;
    private JTextField planningWindowStartField;
    private AbstractAction advancePlanningWindowStartAction;
    private EmployeePanel unassignedPanel;
    private Map<Employee, EmployeePanel> employeeToPanelMap;

    public NurseRosteringPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.createEmployeeListPanel();
        JPanel headerPanel = this.createHeaderPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(this.employeeListPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(this.employeeListPanel, -2, -2, -2));
    }

    public ImageIcon getEmployeeIcon() {
        return this.employeeIcon;
    }

    public ImageIcon getDeleteEmployeeIcon() {
        return this.deleteEmployeeIcon;
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new BorderLayout(20, 0));
        JPanel planningWindowPanel = new JPanel(new FlowLayout(0));
        planningWindowPanel.add(new JLabel("Planning window start:"));
        this.planningWindowStartField = new JTextField(10);
        this.planningWindowStartField.setEditable(false);
        planningWindowPanel.add(this.planningWindowStartField);
        this.advancePlanningWindowStartAction = new AbstractAction("Advance 1 day into the future"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NurseRosteringPanel.this.advancePlanningWindowStart();
            }
        };
        this.advancePlanningWindowStartAction.setEnabled(false);
        planningWindowPanel.add(new JButton(this.advancePlanningWindowStartAction));
        headerPanel.add((Component)planningWindowPanel, "West");
        JLabel shiftTypeExplanation = new JLabel("E = Early shift, L = Late shift, ...");
        headerPanel.add((Component)shiftTypeExplanation, "Center");
        return headerPanel;
    }

    private void createEmployeeListPanel() {
        this.employeeListPanel = new JPanel();
        this.employeeListPanel.setLayout(new BoxLayout(this.employeeListPanel, 1));
        this.unassignedPanel = new EmployeePanel(this, Collections.emptyList(), Collections.emptyList(), null);
        this.employeeListPanel.add(this.unassignedPanel);
        this.employeeToPanelMap = new LinkedHashMap<Employee, EmployeePanel>();
        this.employeeToPanelMap.put(null, this.unassignedPanel);
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    @Override
    public void resetPanel(NurseRoster nurseRoster) {
        for (EmployeePanel employeePanel : this.employeeToPanelMap.values()) {
            if (employeePanel.getEmployee() == null) continue;
            this.employeeListPanel.remove(employeePanel);
        }
        this.employeeToPanelMap.clear();
        this.employeeToPanelMap.put(null, this.unassignedPanel);
        this.unassignedPanel.clearShiftAssignments();
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        List<Shift> shiftList = nurseRoster.getShiftList();
        this.unassignedPanel.setShiftDateListAndShiftList(shiftDateList, shiftList);
        this.updatePanel(nurseRoster);
        this.advancePlanningWindowStartAction.setEnabled(true);
        this.planningWindowStartField.setText(nurseRoster.getNurseRosterParametrization().getPlanningWindowStart().getLabel());
    }

    @Override
    public void updatePanel(NurseRoster nurseRoster) {
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        List<Shift> shiftList = nurseRoster.getShiftList();
        LinkedHashSet<Employee> deadEmployeeSet = new LinkedHashSet<Employee>(this.employeeToPanelMap.keySet());
        deadEmployeeSet.remove(null);
        for (Employee employee : nurseRoster.getEmployeeList()) {
            deadEmployeeSet.remove(employee);
            EmployeePanel employeePanel = this.employeeToPanelMap.get(employee);
            if (employeePanel == null) {
                employeePanel = new EmployeePanel(this, shiftDateList, shiftList, employee);
                this.employeeListPanel.add(employeePanel);
                this.employeeToPanelMap.put(employee, employeePanel);
            }
            employeePanel.clearShiftAssignments();
        }
        this.unassignedPanel.clearShiftAssignments();
        for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
            Employee employee = shiftAssignment.getEmployee();
            EmployeePanel employeePanel = this.employeeToPanelMap.get(employee);
            employeePanel.addShiftAssignment(shiftAssignment);
        }
        for (Employee deadEmployee : deadEmployeeSet) {
            EmployeePanel deadEmployeePanel = this.employeeToPanelMap.remove(deadEmployee);
            this.employeeListPanel.remove(deadEmployeePanel);
        }
        for (EmployeePanel employeePanel : this.employeeToPanelMap.values()) {
            employeePanel.update();
        }
    }

    private void advancePlanningWindowStart() {
        this.logger.info("Advancing planningWindowStart.");
        if (this.solutionBusiness.isSolving()) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "The GUI does not support this action yet during solving.\nOptaPlanner itself does support it.\n\nTerminate solving first and try again.", "Unsupported in GUI", 1);
            return;
        }
        this.doProblemFactChange(scoreDirector -> {
            ShiftDate planningWindowStart;
            NurseRoster nurseRoster = (NurseRoster)scoreDirector.getWorkingSolution();
            NurseRosterParametrization nurseRosterParametrization = nurseRoster.getNurseRosterParametrization();
            List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
            int windowStartIndex = shiftDateList.indexOf(planningWindowStart = nurseRosterParametrization.getPlanningWindowStart());
            if (windowStartIndex < 0) {
                throw new IllegalStateException("The planningWindowStart (" + planningWindowStart + ") must be in the shiftDateList (" + shiftDateList + ").");
            }
            ShiftDate oldLastShiftDate = shiftDateList.get(shiftDateList.size() - 1);
            ShiftDate newShiftDate = new ShiftDate();
            newShiftDate.setId(oldLastShiftDate.getId() + 1L);
            newShiftDate.setDayIndex(oldLastShiftDate.getDayIndex() + 1);
            newShiftDate.setDateString(oldLastShiftDate.determineNextDateString());
            newShiftDate.setDayOfWeek(oldLastShiftDate.getDayOfWeek().determineNextDayOfWeek());
            List<Shift> refShiftList = planningWindowStart.getShiftList();
            ArrayList<Shift> newShiftList = new ArrayList<Shift>(refShiftList.size());
            newShiftDate.setShiftList(newShiftList);
            nurseRoster.getShiftDateList().add(newShiftDate);
            scoreDirector.afterProblemFactAdded((Object)newShiftDate);
            Shift oldLastShift = nurseRoster.getShiftList().get(nurseRoster.getShiftList().size() - 1);
            long shiftId = oldLastShift.getId() + 1L;
            int shiftIndex = oldLastShift.getIndex() + 1;
            long shiftAssignmentId = nurseRoster.getShiftAssignmentList().get(nurseRoster.getShiftAssignmentList().size() - 1).getId() + 1L;
            for (Shift refShift : refShiftList) {
                Shift newShift = new Shift();
                newShift.setId(shiftId);
                ++shiftId;
                newShift.setShiftDate(newShiftDate);
                newShift.setShiftType(refShift.getShiftType());
                newShift.setIndex(shiftIndex);
                ++shiftIndex;
                newShift.setRequiredEmployeeSize(refShift.getRequiredEmployeeSize());
                newShiftList.add(newShift);
                nurseRoster.getShiftList().add(newShift);
                scoreDirector.afterProblemFactAdded((Object)newShift);
                for (int indexInShift = 0; indexInShift < newShift.getRequiredEmployeeSize(); ++indexInShift) {
                    ShiftAssignment newShiftAssignment = new ShiftAssignment();
                    newShiftAssignment.setId(shiftAssignmentId);
                    ++shiftAssignmentId;
                    newShiftAssignment.setShift(newShift);
                    newShiftAssignment.setIndexInShift(indexInShift);
                    nurseRoster.getShiftAssignmentList().add(newShiftAssignment);
                    scoreDirector.afterEntityAdded((Object)newShiftAssignment);
                }
            }
            ShiftDate newPlanningWindowStart = shiftDateList.get(++windowStartIndex);
            nurseRosterParametrization.setPlanningWindowStart(newPlanningWindowStart);
            nurseRosterParametrization.setLastShiftDate(newShiftDate);
            scoreDirector.afterProblemFactChanged((Object)nurseRosterParametrization);
        }, true);
    }

    public void deleteEmployee(Employee employee) {
        this.logger.info("Scheduling delete of employee ({}).", (Object)employee);
        this.doProblemFactChange(scoreDirector -> {
            NurseRoster nurseRoster = (NurseRoster)scoreDirector.getWorkingSolution();
            for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
                if (!Objects.equals(shiftAssignment.getEmployee(), employee)) continue;
                scoreDirector.beforeVariableChanged((Object)shiftAssignment, "employee");
                shiftAssignment.setEmployee(null);
                scoreDirector.afterVariableChanged((Object)shiftAssignment, "employee");
            }
            scoreDirector.triggerVariableListeners();
            nurseRoster.setEmployeeList(new ArrayList<Employee>(nurseRoster.getEmployeeList()));
            Iterator<Employee> it = nurseRoster.getEmployeeList().iterator();
            while (it.hasNext()) {
                Employee workingEmployee = it.next();
                if (!Objects.equals(workingEmployee, employee)) continue;
                scoreDirector.beforeProblemFactRemoved((Object)workingEmployee);
                it.remove();
                scoreDirector.afterProblemFactRemoved((Object)employee);
                break;
            }
        });
    }

    public void moveShiftAssignmentToEmployee(ShiftAssignment shiftAssignment, Employee toEmployee) {
        this.solutionBusiness.doChangeMove(shiftAssignment, "employee", toEmployee);
        this.solverAndPersistenceFrame.resetScreen();
    }
}

