/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.util.ArrayList;
import java.util.List;

public class StringDataGenerator {
    private final String delimiter;
    private List<String[]> partValuesList = new ArrayList<String[]>();
    private int partValuesLength;
    private int index = 0;
    private int indexLimit;
    private int[][] halfSequenceMap = new int[][]{new int[0], {0}, {0, 1}, {0, 2, 1}, {0, 2, 1, 3}};

    public static StringDataGenerator build10kFullNames() {
        return new StringDataGenerator().addPart("Amy", "Beth", "Chad", "Dan", "Elsa", "Flo", "Gus", "Hugo", "Ivy", "Jay").addPart("A.", "B.", "C.", "D.", "E.", "F.", "G.", "H.", "I.", "J.").addPart("O.", "P.", "Q.", "R.", "S.", "T.", "U.", "V.", "W.", "X.").addPart("Cole", "Fox", "Green", "Jones", "King", "Li", "Poe", "Rye", "Smith", "Watt");
    }

    public static StringDataGenerator build1kCompanyNames() {
        return new StringDataGenerator().addPart("Steel", "Paper", "Stone", "Wood", "Water", "Food", "Oil", "Car", "Power", "Computer").addPart("Inc", "Corp", "Limited", "Express", "Telco", "Mobile", "Soft", "Mart", "Bank", "Labs").addPart("US", "UK", "JP", "DE", "FR", "BE", "NL", "BR", "IN", "ES");
    }

    public static StringDataGenerator build10kLocationNames() {
        return new StringDataGenerator().addPart("Los", "San", "Las", "Santa", "New", "Fort", "Mount", "Saint", "Little", "El").addPart("Angeles", "Francisco", "Vegas", "Barbara", "York", "Collins", "Vernon", "Peter", "Rock", "Paso").addPart("Town", "City", "Falls", "Ville", "Field", "Polis", "Shire", "Berg", "Borough", "Island").addPart("AL", "CA", "DE", "FL", "GA", "HI", "IN", "KS", "LA", "ME");
    }

    public StringDataGenerator() {
        this(" ");
    }

    public StringDataGenerator(String delimiter) {
        this.delimiter = delimiter;
    }

    public StringDataGenerator addPart(String ... partValues) {
        if (this.partValuesList.isEmpty()) {
            this.partValuesLength = partValues.length;
        } else if (partValues.length != this.partValuesLength) {
            throw new IllegalStateException("The partValues length (" + partValues.length + ") is not the same as the partValuesLength (" + this.partValuesLength + ") of the others.");
        }
        this.partValuesList.add(partValues);
        this.indexLimit = (int)Math.pow(this.partValuesLength, this.partValuesList.size());
        return this;
    }

    public String generateNextValue() {
        int i;
        if (this.index >= this.indexLimit) {
            throw new IllegalStateException("No more elements: the index (" + this.index + ") is too high.");
        }
        int listSize = this.partValuesList.size();
        StringBuilder result = new StringBuilder(listSize * 80);
        if (listSize >= this.halfSequenceMap.length) {
            throw new IllegalStateException("A listSize (" + listSize + ") is not yet supported.");
        }
        int[] halfSequence = this.halfSequenceMap[listSize];
        int[] chosens = new int[listSize];
        int previousChosen = 0;
        for (i = 0; i < listSize; ++i) {
            int chosen;
            chosens[i] = chosen = (previousChosen + this.index % (int)Math.pow(this.partValuesLength, halfSequence[i] + 1) / (int)Math.pow(this.partValuesLength, halfSequence[i])) % this.partValuesLength;
            previousChosen = chosen;
        }
        for (i = 0; i < listSize; ++i) {
            if (i > 0) {
                result.append(this.delimiter);
            }
            String[] partValues = this.partValuesList.get(i);
            result.append(partValues[chosens[i]]);
        }
        ++this.index;
        return result.toString();
    }

    public void reset() {
        this.index = 0;
    }
}

